package com.testor.module.notice.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.biz.file.model.dto.FileDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

@Data
public class DetailNotice {
    @ApiModelProperty(value = "公告id", required = true)
    private String id;
    @ApiModelProperty(value = "公告标题" , required = true)
    private String title;
    @ApiModelProperty(value = "公告内容" , required = true)
    private String content;
    @ApiModelProperty(value = "附件名称")
    private String fileName;
    @ApiModelProperty(value = "附件id")
    private String refId;
    @ApiModelProperty(value = "附件路径")
    private String filePath;
    @ApiModelProperty(value = "接收对象" , required = true)
    private String receiverObj;
    @ApiModelProperty(value = "用于回显字段" , required = true)
    private String acceptObj;
    @ApiModelProperty(value = "公告状态")
    private String status;
    @ApiModelProperty(value = "流程状态  3 提交（待审核）4 草稿 5 审核通过 6 撤销发布 7 驳回（审核失败）")
    private String processStatus;
    @ApiModelProperty(value = "状态 0 未读 1 已读")
    @TableField("is_read")
    private String isRead;
    @ApiModelProperty(value = "创建时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;
    @ApiModelProperty(value = "最后一次更新时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateDate;
    @ApiModelProperty(value = "发布时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date releaseTime;
    @ApiModelProperty(value = "流程实例id")
    private String processId;
    @ApiModelProperty(value = "驳回意见")
    private String rejectOpinion ;
    private List<FileDTO> fileDTOS;
    private String orgId;
    private String createBy;
}
