package com.testor.module.notice.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;

import java.math.BigDecimal;


/**
 * notice对象 t_sys_notice
 *
 * @author tong-framework
 * @date 2022-04-27 18:10:12
 */
@Data
@Accessors(chain = true)
@TableName("t_sys_notice_top")
@ApiModel(value = "TSysNoticeTop对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TSysNoticeTop{
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @ApiModelProperty(value = "id", required = true)
    @TableId("id")
    private String id;

    /**
     * 公告id
     */
    @ApiModelProperty(value = "公告id", required = true)

    @TableField("notice_id")
    private String noticeId;

    /**
     * 发布单位所属组织机构层级
     */
    @ApiModelProperty(value = "置顶状态 0 正常 1 删除 2 停用 ")

    @TableField("status")
    private String status;

    /**
     * 公告标题
     */
    @ApiModelProperty(value = "公告标题", required = true)

    @TableField("org_id")
    private String orgId;

    /**
     * 公告标题
     */
    @ApiModelProperty(value = "公司所属组织机构层级", required = true)

    @TableField("\"level\"")
    private BigDecimal level;


    public static final String ID = "id";
    public static final String NOTICE_ID = "notice_id";
    public static final String STATUS = "status";
    public static final String ORG_ID = "org_id";
    public static final String LEVEL = "\"level\"";

}
