package com.testor.module.partner.model.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.util.Date;

/**
 * 现场作业_作业统计分析 现场作业统计分析
 *
 * @author testor-framework
 * @date 2022-07-07 14:35:54
 */

@Data
@ApiModel(value = "TJobAccountingDTO 现场作业统计分析")
public class TJobAccountingDTO {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("区域公司 组织机构id")
    private String areaOrgId;

    @ApiModelProperty("基层单位 组织机构id")
    private String grassrootsOrgId;

    @ApiModelProperty(value = "数据类型 数据字典获取（0-全部；1-本单位；2-租赁单位）",dataType = "0")
    private String dateType;

    @ApiModelProperty("作业开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date startDate;

    @ApiModelProperty("作业结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endDate;

}
