package com.testor.module.partner.model.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDate;
import java.util.Date;


/**
 * 相关方组织负责人对象 t_partner_org_res
 *
 * @author testor-framework
 * @date 2022-06-01 14:16:53
 */
@Data
@ApiModel(value = "TPartnerOrgResDTO 相关方组织负责人对象", description = "")
public class TPartnerOrgResDTO extends SuperModel {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id 修改时必填 (列表或者详情接口返回 resId)")
    private String id;
    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "组织机构id")
    private String orgId;
    /**
     * 类型id
     */
    @ApiModelProperty(value = "类型id", required = true)
    private String typeId;

    /**
     * 相关方id
     */
    @ApiModelProperty(value = "相关方id", required = true)
    private String partnerId;

    /**
     * 现场负责人
     */
    @ApiModelProperty(value = "现场负责人", required = true)
    private String responsiblePerson;
    /**
     * 联系方式
     */
    @ApiModelProperty(value = "联系方式", required = true)
    private String phone;
    /**
     * 合同日期
     */
    @ApiModelProperty(value = "合同日期", required = true)
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date contractStartDate;
    /**
     * 合同日期
     */
    @ApiModelProperty(value = "合同日期", required = true)
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date contractEndDate;

    /**
     * 资质状态（0-异常，1-正常）
     */
    @ApiModelProperty(value = "资质状态（0-异常，1-正常）,默认1", example = "1")
    private Integer certificateStatus;

    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")
    private String tenantId;

}
