package com.testor.module.production.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 安全生产事故配置对象 t_production_accident
 * 
 * @author testor-framework
 * @date 2022-11-17 11:37:56
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_production_accident")
@ApiModel(value = "TProductionAccident对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TProductionAccident extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 机构id 主键
 */
  @ApiModelProperty(value = "机构id 主键")

  @TableId("org_id")
  private String orgId;
/**
 * 机构名称
 */
  @ApiModelProperty(value = "机构名称")

  @TableField("org_name")
  private String orgName;
/**
 * 连续无生产事故天数开始计算日期
 */
  @ApiModelProperty(value = "连续无生产事故天数开始计算日期")

  @TableField("data")
  private String data;

  public static final String ORG_ID ="org_id";
  public static final String ORG_NAME ="org_name";
  public static final String DATA ="data";

  @JsonIgnore
  public String getId(){
  	return this.orgId;
  }
  @JsonIgnore
  public void setId(String orgId){
  	this.orgId = orgId;
  }

}
