package com.testor.module.safe.controller;

import com.testor.module.safe.model.domain.TSafeHazardStandardType;
import com.testor.module.safe.model.dto.TSafeHazardStandardTypeAllVO;
import com.testor.module.safe.model.dto.TSafeHazardStandardTypeDelParam;
import com.testor.module.safe.model.dto.TSafeHazardStandardTypeEditDTO;
import com.testor.module.safe.model.dto.TSafeHazardStandardTypeParam;
import com.testor.module.safe.model.vo.TSafeHazardStandardTypeVO;
import com.testor.module.safe.service.TSafeHazardStandardTypeService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 巡检排查标准管理Controller
 *
 * @author testor-framework
 * @date 2022-08-08 10:55:55
 */
@RestController
@RequestMapping("/module/safe/hazard/standard/type")
@Api(value = "TSafeHazardStandardType", tags = "功能配置-隐患排查治理-巡检排查标准管理")
@Slf4j
public class TSafeHazardStandardTypeController extends SuperController {
    @Autowired
    private TSafeHazardStandardTypeService tSafeHazardStandardTypeService;

    @ApiOperation(value = "新增 巡检排查标准管理", notes = "Add TSafeHazardStandardType")
    @PostMapping(value = "/add")
    public BaseResponse<TSafeHazardStandardType> addEntity(@RequestBody TSafeHazardStandardTypeEditDTO addRequest) {
        return tSafeHazardStandardTypeService.addEntity(addRequest);
    }

    /*@ApiOperation(value = "获取 巡检排查标准管理 ", notes = "Get TSafeHazardStandardType By Id")
    @GetMapping(value = "/get")
    public BaseResponse<TSafeHazardStandardType> getById(String id) {
        BaseResponse<TSafeHazardStandardType> baseResponse = new BaseResponse<>();
        if (StringHelper.isNotEmpty(id)) {
            // TODO 按需求添加业务异常判断
            TSafeHazardStandardType data = tSafeHazardStandardTypeService.getById(id);
            baseResponse.setData(data);
        }
        return baseResponse;
    }*/

    @ApiOperation(value = "修改 巡检排查标准管理 ", notes = "Update TSafeHazardStandardType By Id")
    @PutMapping(value = "/update")
    public BaseResponse<TSafeHazardStandardType> updateEntity(@RequestBody TSafeHazardStandardTypeEditDTO updateRequest) {
        return tSafeHazardStandardTypeService.updateEntity(updateRequest);
    }

    /*@ApiOperation(value = "删除 巡检排查标准管理 ", notes = "delete TSafeHazardStandardType By Id")
    @PutMapping(value = "/delete")
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TSafeHazardStandardTypeDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && StringHelper.isNotEmpty(deleteRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TSafeHazardStandardType data = new TSafeHazardStandardType();
            data.setId(deleteRequest.getId());
            data.setStatus(BizConstants.STATUS_DELETE);
            boolean result = tSafeHazardStandardTypeService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }*/

    @ApiOperation(value = "批量删除巡检排查标准管理", notes = "delete TSafeHazardStandardType by batch Id")
    @PutMapping(value = "/batch_delete")
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(
            @RequestBody TSafeHazardStandardTypeDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            // 批量删除
            List<TSafeHazardStandardType> tSafeHazardStandardTypeList = new ArrayList<>();
            for (String id : deleteRequest.getIds()) {
                TSafeHazardStandardType data = new TSafeHazardStandardType();
                data.setId(id);
                data.setStatus(BizConstants.STATUS_DELETE);
                tSafeHazardStandardTypeList.add(data);
            }
            boolean result = tSafeHazardStandardTypeService.updateBatchById(tSafeHazardStandardTypeList);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 巡检排查标准管理 分页列表", notes = "List TSafeHazardStandardType with page")
    @GetMapping(value = "/list")
    public BaseResponse<BaseResponseList<TSafeHazardStandardTypeVO>> listEntity(TSafeHazardStandardTypeParam param) {
        return tSafeHazardStandardTypeService.listEntity(param);
    }

    @ApiOperation(value = "获取 巡检排查标准管理 列表（完整数据）", notes = "List TSafeHazardStandardType with page")
    @GetMapping(value = "/listAll")
    public BaseResponse<List<TSafeHazardStandardTypeAllVO>> listAll() {
        return tSafeHazardStandardTypeService.listAll();
    }

    /*@ApiOperation(value = "获取 巡检排查标准管理 列表", notes = "List TSafeHazardStandardType all")
    @GetMapping(value = "/datas")
    public BaseResponse<BaseResponseList<TSafeHazardStandardType>> listAllEntity(TSafeHazardStandardTypeParam param) {
        BaseResponse<BaseResponseList<TSafeHazardStandardType>> baseResponse = new BaseResponse<>();
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TSafeHazardStandardType> queryWrapper = this.createQuery(param);
        List<TSafeHazardStandardType> resultList = tSafeHazardStandardTypeService.list(queryWrapper);
        BaseResponseList<TSafeHazardStandardType> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal(resultList.size());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }*/

    /* Private Methods */


}
