package com.testor.module.safeCheck.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.safeCheck.model.domain.TSafeCheckPerson;
import com.testor.module.safeCheck.model.dto.TSafeCheckPersonParam;
import com.testor.module.safeCheck.model.dto.TSafeCheckPersonDelParam;
import com.testor.module.safeCheck.service.TSafeCheckPersonService;

/**
 * 安全检查任务检查人员安排Controller
 *
 * @author testor-framework
 * @date 2024-09-03 08:04:18
 */
@RestController
@RequestMapping("/safeCheck/person")
@Api(value = "TSafeCheckPerson", tags = "安全检查任务检查人员安排")
@Slf4j
public class TSafeCheckPersonController extends SuperController
{
    @Autowired
    private TSafeCheckPersonService tSafeCheckPersonService;

    /* Generated Method*/
	@ApiOperation(value = "新增 安全检查任务检查人员安排", notes = "Add TSafeCheckPerson")
	@PostMapping(value = "/add")
	public BaseResponse<TSafeCheckPerson>addEntity(@RequestBody TSafeCheckPerson addRequest) {
		BaseResponse<TSafeCheckPerson> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TSafeCheckPerson data=BeanHelper.beanToBean(addRequest,  TSafeCheckPerson.class);
			data.setId(id);
			boolean result= tSafeCheckPersonService.save(data);
			if(result){
                TSafeCheckPerson newEntity = new TSafeCheckPerson();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 安全检查任务检查人员安排 ", notes = "Get TSafeCheckPerson By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TSafeCheckPerson> getById(String id){
		BaseResponse<TSafeCheckPerson> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TSafeCheckPerson data= tSafeCheckPersonService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 安全检查任务检查人员安排 ", notes = "Update TSafeCheckPerson By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TSafeCheckPerson updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TSafeCheckPerson data=BeanHelper.beanToBean(updateRequest, TSafeCheckPerson.class);
			boolean result= tSafeCheckPersonService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 安全检查任务检查人员安排 ", notes = "delete TSafeCheckPerson By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TSafeCheckPersonDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TSafeCheckPerson data= new TSafeCheckPerson();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tSafeCheckPersonService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除安全检查任务检查人员安排", notes = "delete TSafeCheckPerson by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TSafeCheckPersonDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TSafeCheckPerson> tSafeCheckPersonList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TSafeCheckPerson data= new TSafeCheckPerson();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tSafeCheckPersonList.add(data);
			}
			boolean result = tSafeCheckPersonService.updateBatchById(tSafeCheckPersonList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 安全检查任务检查人员安排 分页列表", notes = "List TSafeCheckPerson with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TSafeCheckPerson>>listEntity(TSafeCheckPersonParam param){
		BaseResponse<BaseResponseList<TSafeCheckPerson>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TSafeCheckPerson> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TSafeCheckPerson> queryWrapper=this.createQuery(param);
		Page<TSafeCheckPerson> resultList= tSafeCheckPersonService.page(resultPage,queryWrapper);
		BaseResponseList<TSafeCheckPerson> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 安全检查任务检查人员安排 列表", notes = "List TSafeCheckPerson all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TSafeCheckPerson>>listAllEntity(TSafeCheckPersonParam param){
		BaseResponse<BaseResponseList<TSafeCheckPerson>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TSafeCheckPerson> queryWrapper=this.createQuery(param);
		List<TSafeCheckPerson> resultList=tSafeCheckPersonService.list(queryWrapper);
		BaseResponseList<TSafeCheckPerson> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TSafeCheckPerson> createQuery(TSafeCheckPersonParam queryParam){
		QueryWrapper<TSafeCheckPerson> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getPlanId())){
			queryWrapper.eq(TSafeCheckPerson.PLAN_ID,queryParam.getPlanId());
		}
		if(StringHelper.isNotEmpty(queryParam.getCheckType())){
			queryWrapper.eq(TSafeCheckPerson.CHECK_TYPE,queryParam.getCheckType());
		}
		if(StringHelper.isNotEmpty(queryParam.getFrequency())){
			queryWrapper.eq(TSafeCheckPerson.FREQUENCY,queryParam.getFrequency());
		}
		if(StringHelper.isNotEmpty(queryParam.getStartDate())){
			queryWrapper.eq(TSafeCheckPerson.START_DATE,queryParam.getStartDate());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getStartDayNum())){
			queryWrapper.eq(TSafeCheckPerson.START_DAY_NUM,queryParam.getStartDayNum());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getStartMonthNum())){
			queryWrapper.eq(TSafeCheckPerson.START_MONTH_NUM,queryParam.getStartMonthNum());
		}
		if(StringHelper.isNotEmpty(queryParam.getEndTime())){
			queryWrapper.eq(TSafeCheckPerson.END_TIME,queryParam.getEndTime());
		}
		if(StringHelper.isNotEmpty(queryParam.getEndDate())){
			queryWrapper.eq(TSafeCheckPerson.END_DATE,queryParam.getEndDate());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getEndDayNum())){
			queryWrapper.eq(TSafeCheckPerson.END_DAY_NUM,queryParam.getEndDayNum());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getEndMonthNum())){
			queryWrapper.eq(TSafeCheckPerson.END_MONTH_NUM,queryParam.getEndMonthNum());
		}
		if(StringHelper.isNotEmpty(queryParam.getStartCronExpression())){
			queryWrapper.eq(TSafeCheckPerson.START_CRON_EXPRESSION,queryParam.getStartCronExpression());
		}
		if(StringHelper.isNotEmpty(queryParam.getEndCronExpression())){
			queryWrapper.eq(TSafeCheckPerson.END_CRON_EXPRESSION,queryParam.getEndCronExpression());
		}
		if(StringHelper.isNotEmpty(queryParam.getGenerateTask())){
			queryWrapper.eq(TSafeCheckPerson.GENERATE_TASK,queryParam.getGenerateTask());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TSafeCheckPerson.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TSafeCheckPerson.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TSafeCheckPerson.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
