package com.testor.module.sys.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.sys.model.domain.TSysConfig;
import com.testor.module.sys.model.dto.TSysConfigParam;
import com.testor.module.sys.model.dto.TSysConfigDelParam;
import com.testor.module.sys.service.TSysConfigService;

/**
 * 系统配置Controller
 *
 * @author testor-framework
 * @date 2024-12-24 15:44:32
 */
@RestController
@RequestMapping("/sys/config")
@Api(value = "TSysConfig", tags = "系统配置")
@Slf4j
public class TSysConfigController extends SuperController
{
    @Autowired
    private TSysConfigService tSysConfigService;

    /* Generated Method*/
	@ApiOperation(value = "新增 系统配置", notes = "Add TSysConfig")
	@PostMapping(value = "/add")
	public BaseResponse<TSysConfig>addEntity(@RequestBody TSysConfig addRequest) {
		BaseResponse<TSysConfig> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TSysConfig data=BeanHelper.beanToBean(addRequest,  TSysConfig.class);
			data.setId(id);
			boolean result= tSysConfigService.save(data);
			if(result){
                TSysConfig newEntity = new TSysConfig();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 系统配置 ", notes = "Get TSysConfig By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TSysConfig> getById(String configId){
		BaseResponse<TSysConfig> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(configId)){
			// TODO 按需求添加业务异常判断
            TSysConfig data= tSysConfigService.getById(configId);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 系统配置 ", notes = "Update TSysConfig By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TSysConfig updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TSysConfig data=BeanHelper.beanToBean(updateRequest, TSysConfig.class);
			boolean result= tSysConfigService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 系统配置 ", notes = "delete TSysConfig By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TSysConfigDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TSysConfig data= new TSysConfig();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tSysConfigService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除系统配置", notes = "delete TSysConfig by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TSysConfigDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TSysConfig> tSysConfigList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TSysConfig data= new TSysConfig();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tSysConfigList.add(data);
			}
			boolean result = tSysConfigService.updateBatchById(tSysConfigList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 系统配置 分页列表", notes = "List TSysConfig with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TSysConfig>>listEntity(TSysConfigParam param){
		BaseResponse<BaseResponseList<TSysConfig>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TSysConfig> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TSysConfig> queryWrapper=this.createQuery(param);
		Page<TSysConfig> resultList= tSysConfigService.page(resultPage,queryWrapper);
		BaseResponseList<TSysConfig> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 系统配置 列表", notes = "List TSysConfig all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TSysConfig>>listAllEntity(TSysConfigParam param){
		BaseResponse<BaseResponseList<TSysConfig>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TSysConfig> queryWrapper=this.createQuery(param);
		List<TSysConfig> resultList=tSysConfigService.list(queryWrapper);
		BaseResponseList<TSysConfig> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TSysConfig> createQuery(TSysConfigParam queryParam){
		QueryWrapper<TSysConfig> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getConfigName())){
			queryWrapper.like(TSysConfig.CONFIG_NAME,queryParam.getConfigName());
		}
		if(StringHelper.isNotEmpty(queryParam.getConfigKey())){
			queryWrapper.eq(TSysConfig.CONFIG_KEY,queryParam.getConfigKey());
		}
		if(StringHelper.isNotEmpty(queryParam.getConfigValue())){
			queryWrapper.eq(TSysConfig.CONFIG_VALUE,queryParam.getConfigValue());
		}
		if(StringHelper.isNotEmpty(queryParam.getConfigType())){
			queryWrapper.eq(TSysConfig.CONFIG_TYPE,queryParam.getConfigType());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TSysConfig.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TSysConfig.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TSysConfig.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
