package com.testor.module.train.exam.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;


/**
 * 管理试题——教育培训对象 t_train_test_questions
 * 
 * @author testor-framework
 * @date 2022-07-13 15:22:00
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_train_test_questions")
@ApiModel(value = "TTrainTestQuestions对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TTrainTestQuestions extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 试题类型（单选 多选 判端）
 */
  @ApiModelProperty(value = "试题类型（单选 多选 判端）")

  @TableField("test_questions_type")
  private String testQuestionsType;
/**
 * 试题内容
 */
  @ApiModelProperty(value = "试题内容")

  @TableField("test_questions_content")
  private String testQuestionsContent;
/**
 * 试题名称
 */
  @ApiModelProperty(value = "题库名称")

  @TableField("question_bank_name")
  private String questionBankName;
/**
 * 题库id
 */
  @ApiModelProperty(value = "题库id")

  @TableField("question_bank_id")
  private String questionBankId;
/**
 * 试题解析
 */
  @ApiModelProperty(value = "试题解析")

  @TableField("test_questions_analysis")
  private String testQuestionsAnalysis;
/**
 * 租户id
 */
  @ApiModelProperty(value = "租户id")

  @TableField("tenant_id")
  private String tenantId;
/**
 * 流程状态
 */
  @ApiModelProperty(value = "流程状态")

  @TableField("process_status")
  private String processStatus;
/**
 * 关联ID
 */
  @ApiModelProperty(value = "关联ID")

  @TableField("ref_id")
  private String refId;
/**
 * 流程实例ID
 */
  @ApiModelProperty(value = "流程实例ID")

  @TableField("process_id")
  private String processId;
/**
 * 父级ID
 */
  @ApiModelProperty(value = "父级ID")

  @TableField("parent_id")
  private String parentId;

  /**
   * 创建人姓名
   */
  @ApiModelProperty(value = "创建人姓名")

  @TableField("create_by_name")
  private String createByName;

  /**
   * 更新人姓名
   */
  @ApiModelProperty(value = "更新人姓名")

  @TableField("update_by_name")
  private String updateByName;
  /**
   * 组织机构id
   */
  @ApiModelProperty(value = "组织机构id")

  @TableField("org_id")
  private String orgId;

  public static final String ID ="id";
  public static final String TEST_QUESTIONS_TYPE ="test_questions_type";
  public static final String TEST_QUESTIONS_CONTENT ="test_questions_content";
  public static final String QUESTION_BANK_NAME ="question_bank_name";
  public static final String QUESTION_BANK_ID ="question_bank_id";
  public static final String TEST_QUESTIONS_ANALYSIS ="test_questions_analysis";
  public static final String TENANT_ID ="tenant_id";
  public static final String PROCESS_STATUS ="process_status";
  public static final String REF_ID ="ref_id";
  public static final String PROCESS_ID ="process_id";
  public static final String PARENT_ID ="parent_id";
  public static final String ORG_ID ="org_id";


}
