package com.testor.module.train.examinationManage.model.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * @title TTrainExaminationManageQueryParam
 * @description <TODO description class purpose>
 * @Author: qiao
 * @version:1.0.0
 * @create：4/20/23 5:16 PM
 */
@Data
@ApiModel(value = "扫码考试查询参数对象")
public class TTrainExaminationManageQueryParam {


    /**
     * 考试名称
     */
    @ApiModelProperty(value = "考试名称")
    private String examName;
    /**
     * 考试方式 0 (集体考试)线上 1 (集体考试)线下 3 (随机考试)线上
     */
    @ApiModelProperty(value = "考试方式 0 (集体考试)线上 1 (集体考试)线下 3 (随机考试)线上")
    private String examWay;
    /**
     * 考试类型
     */
    @ApiModelProperty(value = "考试类型")
    private String examType;

    /**
     * 考试结束时间
     */
    @ApiModelProperty(value = "考试结束时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date examEndTime;
    /**
     * 关联试卷id
     */
    @ApiModelProperty(value = "关联试卷id")
    private String paperId;
    /**
     * 考试时长
     */
    @ApiModelProperty(value = "考试时长")
    private String examDuration;

    @ApiModelProperty(value = "myid")
    private String myId;

}
