package com.testor.module.train.project.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;


import java.util.Date;


/**
 * 教育培训计划—安全培训教育对象 t_train_project
 *
 * @author testor-framework
 * @date 2022-07-28 15:15:20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_train_project")
@ApiModel(value = "TTrainProject对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TTrainProject extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")

    @TableId("id")
    private String id;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级id")

    @TableField("parent_id")
    private String parentId;
    /**
     * 培训项目名称
     */
    @ApiModelProperty(value = "培训项目名称")

    @TableField("project_name")
    private String projectName;
    /**
     * 参训开始时间
     */
    @ApiModelProperty(value = "参训开始时间")

    @TableField("visit_start_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date visitStartTime;
    /**
     * 参训结束时间
     */
    @ApiModelProperty(value = "参训结束时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("visit_end_time")
    private Date visitEndTime;
    /**
     * 参训方式
     */
    @ApiModelProperty(value = "参训方式 0 线上 1 线下 2 自主")
    @TableField("visit_way")
    private String visitWay;
    /**
     * 人员类型
     */
    @ApiModelProperty(value = "人员类型")
    @TableField("visit_type")
    private String visitType;
    /**
     * 关联课程id
     */
    @ApiModelProperty(value = "关联课程id")

    @TableField("course_id")
    private String courseId;
    /**
     * 是否添加考试
     */
    @ApiModelProperty(value = "是否添加考试 1 是 0 否")

    @TableField("is_add_exam")
    private String isAddExam;
    /**
     * 试卷id
     */
    @ApiModelProperty(value = "试卷id")

    @TableField("test_paper_id")
    private String testPaperId;
    /**
     * 考试类型
     */
    @ApiModelProperty(value = "考试类型")

    @TableField("exam_type")
    private String examType;
    /**
     * 考试名称
     */
    @ApiModelProperty(value = "考试名称")

    @TableField("exam_name")
    private String examName;
    /**
     * 考试开始时间
     */
    @ApiModelProperty(value = "考试开始时间")

    @TableField("exam_start_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date examStartTime;
    /**
     * 考试结束时间
     */
    @ApiModelProperty(value = "考试结束时间")

    @TableField("exam_end_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date examEndTime;
    /**
     * 考试地点
     */
    @ApiModelProperty(value = "考试地点")

    @TableField("exam_site")
    private String examSite;
    /**
     * 考试时长
     */
    @ApiModelProperty(value = "考试时长")

    @TableField("exam_duration")
    private String examDuration;
    /**
     * 应学人数
     */
    @ApiModelProperty(value = "应学人数")

    @TableField("should_learn_number")
    private String shouldLearnNumber;
    /**
     * 完成人数
     */
    @ApiModelProperty(value = "完成人数")

    @TableField("finish_number")
    private String finishNumber;
    /**
     * 完成率
     */
    @ApiModelProperty(value = "完成率")

    @TableField("percentage")
    private String percentage;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")

    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")

    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")

    @TableField("process_status")
    private String processStatus;
    /**
     * 发布单位
     */
    @ApiModelProperty(value = "发布单位")

    @TableField("org_name")
    private String orgName;

    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "组织机构id")

    @TableField("org_id")
    private String orgId;

    @ApiModelProperty(value = "线下培训签到二维码")
    @TableField("qr_code")
    private String qrCode;

    @ApiModelProperty(value = "参训地点")
    @TableField("visit_site")
    private String visitSite;


    @ApiModelProperty(value = "培训类型 字典 train_type")
    @TableField("train_type")
    private String trainType;


//  @ApiModelProperty(value = "是否线上培训 1 线上 0 线下")
//  @TableField("is_online")
//  private String isOnline;

    public static final String ID = "id";
    public static final String PARENT_ID = "parent_id";
    public static final String PROJECT_NAME = "project_name";
    public static final String VISIT_START_TIME = "visit_start_time";
    public static final String VISIT_END_TIME = "visit_end_time";
    public static final String VISIT_WAY = "visit_way";
    public static final String VISIT_TYPE = "visit_type";
    public static final String COURSE_ID = "course_id";
    public static final String IS_ADD_EXAM = "is_add_exam";
    public static final String TEST_PAPER_ID = "test_paper_id";
    public static final String EXAM_TYPE = "exam_type";
    public static final String EXAM_NAME = "exam_name";
    public static final String EXAM_START_TIME = "exam_start_time";
    public static final String EXAM_END_TIME = "exam_end_time";
    public static final String EXAM_SITE = "exam_site";
    public static final String EXAM_DURATION = "exam_duration";
    public static final String SHOULD_LEARN_NUMBER = "should_learn_number";
    public static final String FINISH_NUMBER = "finish_number";
    public static final String PERCENTAGE = "percentage";
    public static final String TENANT_ID = "tenant_id";
    public static final String PROCESS_ID = "process_id";
    public static final String PROCESS_STATUS = "process_status";
    public static final String ORG_NAME = "org_name";
    public static final String ORG_ID = "org_id";
    public static final String QR_CODE = "qr_code";
    public static final String VISIT_SITE = "visit_site";
    public static final String TRAIN_TYPE = "train_type";
//  public static final String IS_ONLINE ="is_online";


}
