package com.testor.module.train.project.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.testor.module.train.project.dao.TTrainEvaluateManageDao;
import com.testor.module.train.project.model.domain.TTrainEvaluateManage;
import com.testor.module.train.project.model.dto.AssessType;
import com.testor.module.train.project.model.dto.TTrainEvaluateManageParam;
import com.testor.module.train.project.service.TTrainEvaluateManageService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import org.springframework.stereotype.Service;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 评价管理端——安全培训教育Service业务层处理
 *
 * @author testor-framework
 * @date 2022-08-13 14:16:27
 */
@Service
public class TTrainEvaluateManageServiceImpl extends SuperServiceImpl<TTrainEvaluateManageDao, TTrainEvaluateManage> implements TTrainEvaluateManageService {
    @Autowired(required = false)
    private TTrainEvaluateManageDao tTrainEvaluateManageDao;

    @Override
    public BaseResponse<TTrainEvaluateManage> addEvaluate(TTrainEvaluateManageParam addRequest) {
        BaseResponse<TTrainEvaluateManage> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(addRequest)) {
            // 如果存在id 删除评估类型和评估内容
            if (StringHelper.isNotEmpty(addRequest.getId())) {
                deleteAssess(addRequest.getId());
            }
            boolean result = false;
            TTrainEvaluateManage evaluateManage = BeanHelper.beanToBean(addRequest, TTrainEvaluateManage.class);
            String id = IdHelper.getId32bit();
            evaluateManage.setId(id);
            evaluateManage.setParentId("0");
            evaluateManage.setOrgId(ContextUtils.getLoginUser().getOrgId());
            result = this.saveOrUpdate(evaluateManage);
            for (AssessType assessType : addRequest.getAssessTypes()) {
                String typeId = IdHelper.getId32bit();
                assessType.setId(typeId);
                assessType.setAssessState("1");
                assessType.setParentId(id);
                assessType.setAssessMinute(evaluateManage.getAssessMinute());
                TTrainEvaluateManage tepeContent = BeanHelper.beanToBean(assessType, TTrainEvaluateManage.class);
                result = this.saveOrUpdate(tepeContent);
                for (AssessType content : assessType.getAssessContents()) {
                    String contentId = IdHelper.getId32bit();
                    content.setId(contentId);
                    content.setAssessState("2");
                    content.setParentId(typeId);
                    content.setAssessMinute(evaluateManage.getAssessMinute());
                    TTrainEvaluateManage bean = BeanHelper.beanToBean(content, TTrainEvaluateManage.class);
                    result = this.saveOrUpdate(bean);
                }
            }
            if (result) {
                TTrainEvaluateManage newEntity = new TTrainEvaluateManage();
                newEntity.setRefId(id);
                baseResponse.setData(newEntity);
            }
        }
        return baseResponse;
    }

    @Override
    public BaseResponse<TTrainEvaluateManageParam> getEvaluate(TTrainEvaluateManage addRequest) {
        BaseResponse<TTrainEvaluateManageParam> baseResponse = new BaseResponse<>();
        addRequest = this.getOne(new QueryWrapper<TTrainEvaluateManage>().eq(TTrainEvaluateManage.PARENT_ID, "0"));
        if (ObjectHelper.isNotEmpty(addRequest)) {
            String id = addRequest.getId();
            TTrainEvaluateManage manage = getById(id);
            TTrainEvaluateManageParam param = BeanHelper.beanToBean(manage, TTrainEvaluateManageParam.class);
            List<TTrainEvaluateManage> type = list(new QueryWrapper<TTrainEvaluateManage>().eq(TTrainEvaluateManage.PARENT_ID, id));
            List<AssessType> assessTypes = new ArrayList<>();
            for (TTrainEvaluateManage tTrainEvaluateManage : type) {
                String typeId = tTrainEvaluateManage.getId();
                List<TTrainEvaluateManage> contentList = list(new QueryWrapper<TTrainEvaluateManage>().eq(TTrainEvaluateManage.PARENT_ID, typeId));
                for (TTrainEvaluateManage trainEvaluateManage : contentList) {
                    AssessType assessType = new AssessType();
                    assessType.setId(tTrainEvaluateManage.getId());
                    assessType.setAssessState(tTrainEvaluateManage.getAssessContent());
                    assessType.setAssessMinute(trainEvaluateManage.getAssessMinute());
                    assessType.setAssessContent(trainEvaluateManage.getAssessContent());
                    assessTypes.add(assessType);
                }
            }
            param.setAssessTypes(assessTypes);
            baseResponse.setData(param);
        }
        return baseResponse;
    }

    private void deleteAssess(String id) {
        List<TTrainEvaluateManage> list = list(new QueryWrapper<TTrainEvaluateManage>()
                .eq(TTrainEvaluateManage.PARENT_ID, id)
                .or()
                .eq(TTrainEvaluateManage.ID,id)
        );
        this.remove(new QueryWrapper<TTrainEvaluateManage>().eq(TTrainEvaluateManage.PARENT_ID, id));
        List<String> strings = new ArrayList<>();
        for (TTrainEvaluateManage manage : list) {
            strings.add(manage.getId());
        }
        this.remove(new QueryWrapper<TTrainEvaluateManage>().in(TTrainEvaluateManage.PARENT_ID, strings).or().eq(TTrainEvaluateManage.ID,id));
    }

    private void deleteManage(String orgId) {
        // 存储所有父节点id
        List<String> strings = new ArrayList<>();
        // 存储所有子节点id
        List<String> sonList = new ArrayList<>();
        // 获取所有父节点
        List<TTrainEvaluateManage> list = list(new QueryWrapper<TTrainEvaluateManage>()
                .eq(TTrainEvaluateManage.PARENT_ID, "0")
                .eq(TTrainEvaluateManage.ORG_ID,orgId)
        );
        // 得到所有父节点id
        for (TTrainEvaluateManage evaluateManage : list) {
            strings.add(evaluateManage.getId());
        }
        // 得到所有子节点
        List<TTrainEvaluateManage> list1 = list(new QueryWrapper<TTrainEvaluateManage>()
                .in(TTrainEvaluateManage.PARENT_ID, strings)
                .eq(TTrainEvaluateManage.ORG_ID,orgId)
        );
        for (TTrainEvaluateManage evaluateManage : list1) {
            sonList.add(evaluateManage.getId());
        }
        sonList.addAll(strings);
        for (String s : sonList) {
            removeById(s);
        }
    }
}
