//package com.testor.websocket;
//
//import cn.hutool.core.util.StrUtil;
//import com.alibaba.fastjson.JSON;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.stereotype.Component;
//
//import javax.websocket.*;
//import javax.websocket.server.PathParam;
//import javax.websocket.server.ServerEndpoint;
//import java.io.IOException;
//import java.util.Date;
//import java.util.Map;
//import java.util.concurrent.ConcurrentHashMap;
//
//@Slf4j
//@Component
//@ServerEndpoint("/webSocket/{userId}")
//public class WebSocketServer {
//    private static ConcurrentHashMap<String, Session> userInfoMap = new ConcurrentHashMap<>();
//    private static int onlineCount = 0;
//
//    /**
//     * 建立连接调用的方法
//     *
//     * @param session
//     * @param userId
//     */
//    @OnOpen
//    public void onOpen(Session session, @PathParam("userId") String userId) {
//        if (StrUtil.isBlank(userId)) {
//            return;
//        }
//        userInfoMap.put(userId, session);
//        onlineCount = userInfoMap.size();
////        log.info("建立连接成功，当前人数为" + onlineCount);
////        String message = "建立连接成功，当前人数为" + onlineCount;
//
////        Message messageObj = new Message();
////        messageObj.setFrom("System");
////        messageObj.setTo("1242684364872761344");
////        messageObj.setMsg("pong");
////        messageObj.setType("0");
////        messageObj.setSendTime(new Date());
////        sendAllMessageByAsync(messageObj);
//    }
//
//    /**
//     * 收到客户端消息后调用的方法
//     * 后台收到客户端发送过来的消息
//     *
//     * @param userId
//     * @param message 客户端发送过来的消息
//     */
//    @OnMessage
//    public void onMessage(@PathParam("userId") String userId, String message) {
//        try {
//            if (StrUtil.isBlank(message)) {
//                return;
//            }
//            Message messageObj = JSON.parseObject(message, Message.class);
//            if (messageObj.getType().equals("0") && messageObj.getMsg().equals("ping")) {
//               String from = messageObj.getFrom();
//                messageObj.setFrom("System");
//                messageObj.setTo(from);
//                messageObj.setMsg("pong");
//                messageObj.setType("0");
//                messageObj.setSendTime(new Date());
//                sendTextMessage(messageObj);
//                return;
//            }
//            sendTextMessage(messageObj);
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//    }
//
//    @OnError
//    public void onError(Throwable e) {
//        log.info("错误{}", e);
//    }
//
//    /**
//     * 关闭链接调用接口
//     *
//     * @param userId
//     */
//    @OnClose
//    public void onClose(@PathParam("userId") String userId) {
//        if (StrUtil.isBlank(userId)) {
//            return;
//        }
//        userInfoMap.remove(userId);
//        onlineCount = userInfoMap.size();
//        log.info("断开连接成功，当前人数为" + onlineCount);
//    }
//
//    /**
//     * 群发自定义消息
//     * 有两种会话发送信息的方法：
//     * session.getBasicRemote().sendText(message):同步发送信息
//     * session.getAsyncRemote().sendText(message):异步发送信息
//     */
//    public void sendAllMessageBySync(Message message) {
//
//        for (Map.Entry<String, Session> entry : userInfoMap.entrySet()) {
//            try {
//                Session session = entry.getValue();
//                message.setTo(entry.getKey());
//                // 判断会话是否连接
//                if (session.isOpen()) {
//                    // 发送同步信息到当前会话
//                    session.getBasicRemote().sendText(JSON.toJSONString(message));
//                }
//            } catch (IOException e) {
//                e.printStackTrace();
//            }
//        }
//    }
//
//    /**
//     * 此为广播消息
//     * 异步
//     **/
//    public void sendAllMessageByAsync(Message message) {
//        for (Map.Entry<String, Session> entry : userInfoMap.entrySet()) {
//            System.out.println("【websocket消息】广播消息:" + JSON.toJSONString(message));
//            try {
//                Session session = entry.getValue();
//                message.setTo(entry.getKey());
//                if (session.isOpen()) {
//                    // 发送同步信息到当前会话
//                    session.getAsyncRemote().sendText(JSON.toJSONString(message));
//                }
//
//            } catch (Exception e) {
//                e.printStackTrace();
//            }
//        }
//    }
//
//    /**
//     * 此为单点消息:指定发送人 (发送文本)
//     * 同步
//     **/
//
//    public void sendTextMessage(Message message) {
//        if (message == null || StrUtil.isBlank(message.getTo())) {
//            return;
//        }
//        String toUsers = message.getTo();
//        if ("-1".equals(toUsers)) {
//            this.sendAllMessageByAsync(message);
//        }
//
//        String[] toUserArray = toUsers.split(",");
//        Session session;
//        try {
//            for (String userId : toUserArray) {
//                session = userInfoMap.get(userId);
//                if (session != null) {
//                    message.setTo(userId);
//                    session.getBasicRemote().sendText(JSON.toJSONString(message));
//                }
//            }
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//
//    }
//}