/*
 * Decompiled with CFR 0.152.
 */
package com.testor.biz.sys.area.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.sys.area.AreaEnumCode;
import com.testor.biz.sys.area.model.domain.SysArea;
import com.testor.biz.sys.area.model.dto.SysAreaDeleteParam;
import com.testor.biz.sys.area.model.dto.SysAreaListResponse;
import com.testor.biz.sys.area.model.dto.SysAreaParam;
import com.testor.biz.sys.area.model.dto.SysAreaRequest;
import com.testor.biz.sys.area.model.dto.SysAreaResponse;
import com.testor.biz.sys.area.service.SysAreaService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="SysArea", tags={"SysArea \u533a\u57df\u7ba1\u7406"})
@RequestMapping(value={"/area"})
public class SysAreaController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(SysAreaController.class);
    @Autowired
    private SysAreaService sysAreaService;

    @ApiOperation(value="\u65b0\u589e\u533a\u57df", notes="\u65b0\u589e\u533a\u57df Add Area")
    @PostMapping(value={"/add"})
    public BaseResponse<SysAreaResponse> addEntity(@RequestBody SysAreaRequest addRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)addRequest)) {
            if (StringHelper.isEmpty((CharSequence)addRequest.getParentId())) {
                addRequest.setParentId("0");
            }
            SysArea data = (SysArea)((Object)BeanHelper.beanToBean((Object)addRequest, SysArea.class));
            String areaId = IdHelper.getId32bit();
            data.setParentIds(this.queryParentsIds(addRequest.getParentId()));
            data.setAreaId(areaId);
            boolean result = this.sysAreaService.save((Object)data);
            if (result) {
                baseResponse.setData((Object)SysAreaResponse.builder().areaId(areaId).build());
            }
        }
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539\u533a\u57df(ID)", notes="\u4fee\u6539\u533a\u57df(ID) Update SysArea by Id")
    @PutMapping(value={"/update"})
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody SysAreaRequest updateRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)updateRequest) && StringHelper.isNotEmpty((CharSequence)updateRequest.getAreaId())) {
            SysArea data = (SysArea)((Object)BeanHelper.beanToBean((Object)updateRequest, SysArea.class));
            SysArea oldData = (SysArea)((Object)this.sysAreaService.getById((Serializable)((Object)updateRequest.getAreaId())));
            if (StringHelper.isNotEmpty((CharSequence)updateRequest.getParentId()) && !oldData.getParentId().equals(updateRequest.getParentId())) {
                String newParentIds = this.queryParentsIds(updateRequest.getParentId());
                data.setParentIds(newParentIds);
                List<SysArea> subAreas = this.getAllSubArea(updateRequest.getAreaId());
                for (SysArea sysArea : subAreas) {
                    String newIds = this.replaceParentIds(sysArea.getParentIds(), newParentIds, updateRequest.getAreaId());
                    if (StringHelper.isNotEmpty((CharSequence)newIds)) {
                        sysArea.setParentIds(newIds);
                        continue;
                    }
                    log.error("Area Parents Id update Failed - AreaId:" + updateRequest.getParentId() + ", related sub Area: " + sysArea.getAreaId());
                    throw new ApiException(AreaEnumCode.UPDATE_SUB_AREA_ERROR.transform());
                }
                this.sysAreaService.updateBatchById(subAreas);
            }
            boolean result = this.sysAreaService.updateById((Object)data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5220\u9664\u533a\u57df(ID)", notes="\u5220\u9664\u533a\u57df(ID) delete SysArea by Id")
    @PutMapping(value={"/delete"})
    public BaseResponse<SysAreaResponse> deleteEntity(@RequestBody SysAreaDeleteParam areaId) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)areaId.getAreaId())) {
            SysArea data = new SysArea();
            data.setAreaId(areaId.getAreaId());
            data.setStatus("1");
            List parentAreaList = this.sysAreaService.list((Wrapper)new QueryWrapper().lambda().like(SysArea::getParentIds, (Object)data.getAreaId()));
            this.sysAreaService.updateBatchById(parentAreaList.stream().peek(area -> area.setStatus("1")).collect(Collectors.toList()));
            boolean result = this.sysAreaService.updateById((Object)data);
            baseResponse.setData((Object)SysAreaResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6\u533a\u57df\u4fe1\u606f(ID)", notes="\u83b7\u53d6\u533a\u57df\u4fe1\u606f(ID) Get SysArea By Id")
    @GetMapping(value={"/get"})
    public BaseResponse<SysAreaResponse> getById(String areaId) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)areaId)) {
            SysArea data = (SysArea)((Object)this.sysAreaService.getById((Serializable)((Object)areaId)));
            if (ObjectHelper.isEmpty((Object)((Object)data))) {
                throw new ApiException(AreaEnumCode.AREA_ID_NOT_EXISTED.transform());
            }
            SysAreaResponse sysAreaResponse = (SysAreaResponse)BeanHelper.beanToBean((Object)((Object)data), SysAreaResponse.class);
            baseResponse.setData((Object)sysAreaResponse);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6240\u6709\u533a\u57df\u5217\u8868", notes="\u6240\u6709\u533a\u57df\u5217\u8868 List Areas")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<SysAreaListResponse>> listAllEntity(SysAreaParam param) {
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper<SysArea> queryWrapper = this.createQuery(param);
        List resultList = this.sysAreaService.list((Wrapper)queryWrapper).stream().map(e -> (SysAreaListResponse)e.beanToBean(SysAreaListResponse.class)).collect(Collectors.toList());
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal((long)resultList.size());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u5206\u9875\u533a\u57df\u5217\u8868", notes="\u5206\u9875\u533a\u57df\u5217\u8868 List Areas with Page")
    @GetMapping(value={"/listAreas"})
    public BaseResponse<BaseResponseList<SysArea>> listEntity(SysAreaParam param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<SysArea> queryWrapper = this.createQuery(param);
        Page resultList = (Page)this.sysAreaService.page((IPage)resultPage, (Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal() + "");
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    private QueryWrapper<SysArea> createQuery(SysAreaParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getAreaId())) {
            queryWrapper.like((Object)"parent_ids", (Object)queryParam.getAreaId());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getAreaType())) {
            queryWrapper.eq((Object)"area_type", (Object)queryParam.getAreaType());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        } else {
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByAsc((Object)"tree_sort");
        }
        return queryWrapper;
    }

    private String queryParentsIds(String pid) {
        String pids = pid;
        if ("0".equals(pid)) {
            return pids + ",";
        }
        pid = ((SysArea)((Object)this.sysAreaService.getById((Serializable)((Object)pid)))).getParentIds();
        pids = pid + pids + ",";
        return pids;
    }

    private List<SysArea> getAllSubArea(String areaId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.like((Object)"parent_ids", (Object)areaId);
        return this.sysAreaService.list((Wrapper)queryWrapper);
    }

    private String replaceParentIds(String oldIds, String newIds, String areaId) {
        String[] splited = oldIds.split("," + areaId + ",");
        newIds = splited.length == BizConstants.PARENTS_ID_SPLIT_END ? newIds + areaId + "," : (splited.length == BizConstants.PARENTS_ID_SPLIT_LENGTH ? newIds + areaId + "," + splited[1] : "");
        return newIds;
    }
}

