/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.core.helper;

import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.text.StrFormatter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.util.StringUtils;

public class StringHelper {
    public static String toCamelCase(String s) {
        if (s == null) {
            return null;
        }
        s = s.toLowerCase();
        StringBuilder sb = new StringBuilder(s.length());
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_') {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String convertToCamelCase(String name) {
        String[] camels;
        StringBuilder result = new StringBuilder();
        if (name == null || name.isEmpty()) {
            return "";
        }
        if (!name.contains("_")) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        for (String camel : camels = name.split("_")) {
            if (camel.isEmpty()) continue;
            result.append(camel.substring(0, 1).toUpperCase());
            result.append(camel.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String format(String template, Object ... params) {
        if (StringHelper.isEmpty(params) || StringHelper.isEmpty(template)) {
            return template;
        }
        return StrFormatter.format(template, params);
    }

    public static boolean isNotBlank(CharSequence charSequence) {
        return StringUtils.hasText((CharSequence)charSequence);
    }

    public static boolean isBlank(CharSequence charSequence) {
        return !StringHelper.isNotBlank(charSequence);
    }

    public static boolean isNotEmpty(CharSequence charSequence) {
        return StringUtils.hasLength((CharSequence)charSequence);
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return !StringHelper.isNotEmpty(charSequence);
    }

    public static boolean isEmpty(Collection<?> coll) {
        return StringHelper.isNull(coll) || coll.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return !StringHelper.isEmpty(coll);
    }

    public static boolean isEmpty(Object[] objects) {
        return StringHelper.isNull(objects) || objects.length == 0;
    }

    public static boolean isNotEmpty(Object[] objects) {
        return !StringHelper.isEmpty(objects);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return StringHelper.isNull(map) || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !StringHelper.isEmpty(map);
    }

    public static boolean isNull(Object object) {
        return Objects.isNull(object);
    }

    public static boolean isNotNull(Object object) {
        return !StringHelper.isNull(object);
    }

    public static boolean startWith(CharSequence charSequence, CharSequence prefix, boolean ignoreCase) {
        if (null == charSequence || null == prefix) {
            return false;
        }
        if (ignoreCase) {
            return charSequence.toString().toLowerCase().startsWith(prefix.toString().toLowerCase());
        }
        return charSequence.toString().startsWith(prefix.toString());
    }

    public static boolean startWith(CharSequence charSequence, CharSequence prefix) {
        return StringHelper.startWith(charSequence, prefix, false);
    }

    public static boolean startWithIgnoreCase(CharSequence charSequence, CharSequence prefix) {
        return StringHelper.startWith(charSequence, prefix, true);
    }

    public static String removePrefix(CharSequence charSequence, CharSequence prefix) {
        if (null == charSequence || null == prefix) {
            return StringHelper.toString(charSequence);
        }
        if (StringHelper.startWith(charSequence, prefix)) {
            return StringHelper.toString(charSequence.subSequence(prefix.length(), charSequence.length()));
        }
        return StringHelper.toString(charSequence);
    }

    public static boolean endsWith(CharSequence str, CharSequence suffix) {
        return StringHelper.endsWith(str, suffix, false);
    }

    public static boolean endsWithIgnoreCase(CharSequence str, CharSequence suffix) {
        return StringHelper.endsWith(str, suffix, true);
    }

    private static boolean endsWith(CharSequence str, CharSequence suffix, boolean ignoreCase) {
        if (str != null && suffix != null) {
            if (suffix.length() > str.length()) {
                return false;
            }
            int strOffset = str.length() - suffix.length();
            return StringHelper.regionMatches(str, ignoreCase, strOffset, suffix, 0, suffix.length());
        }
        return str == null && suffix == null;
    }

    public static boolean regionMatches(CharSequence cs, boolean ignoreCase, int thisStart, CharSequence substring, int start, int length) {
        if (cs instanceof String && substring instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, thisStart, (String)substring, start, length);
        }
        int index1 = thisStart;
        int index2 = start;
        int totalLength = length;
        while (totalLength-- > 0) {
            char c2;
            char c1;
            if ((c1 = cs.charAt(index1++)) == (c2 = substring.charAt(index2++))) continue;
            if (!ignoreCase) {
                return false;
            }
            if (Character.toUpperCase(c1) == Character.toUpperCase(c2) || Character.toLowerCase(c1) == Character.toLowerCase(c2)) continue;
            return false;
        }
        return true;
    }

    public static String repeat(char c, int count) {
        if (0 >= count) {
            return "";
        }
        char[] charArray = new char[count];
        while (count != 0) {
            charArray[count - 1] = c;
            --count;
        }
        return new String(charArray);
    }

    public static String substring(String data, int start, int end) {
        if (null == data) {
            return null;
        }
        if (end < 0) {
            end = data.length() + end;
        }
        if (start < 0) {
            start = data.length() + start;
        }
        if (end > data.length()) {
            end = data.length();
        }
        if (start > end) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return data.substring(start, end);
    }

    public static boolean equalsAnyIgnoreCase(CharSequence charSequence1, CharSequence ... searchStrings) {
        if (ObjectHelper.isNotEmpty(charSequence1) && ObjectHelper.isNotEmpty(searchStrings)) {
            CharSequence[] charSequences2 = searchStrings;
            int counter = searchStrings.length;
            for (int member = 0; member < counter; ++member) {
                CharSequence next = charSequences2[member];
                if (!charSequence1.toString().equalsIgnoreCase(next.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static String toString(Object object) {
        return StringHelper.toString(object, null);
    }

    public static String toString(Object object, String defaultValue) {
        return StringHelper.toString(object, defaultValue, null);
    }

    public static String toString(Object object, String defaultValue, String charset) {
        if (null == object) {
            return defaultValue;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof byte[] || object instanceof Byte[]) {
            return StringHelper.toString((byte[])object, charset);
        }
        if (object instanceof ByteBuffer) {
            return StringHelper.toString((ByteBuffer)object, charset);
        }
        return ObjectHelper.toString(object);
    }

    public static String toString(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static String toString(ByteBuffer data, String charset) {
        if (null == data) {
            return null;
        }
        return StringHelper.toString(data, Charset.forName(charset));
    }

    public static String toString(byte[] data, Charset charset) {
        if (null == data) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String toString(byte[] bytes, String charset) {
        return StringHelper.toString(bytes, StringHelper.isEmpty(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String toSBC(String input) {
        return StringHelper.toSBC(input, null);
    }

    public static String toSBC(String input, Set<Character> notConvertSet) {
        char[] chars = input.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(chars[i]))) continue;
            if (chars[i] == ' ') {
                chars[i] = 12288;
                continue;
            }
            if (chars[i] >= '\u007f') continue;
            chars[i] = (char)(chars[i] + 65248);
        }
        return new String(chars);
    }

    public static String toDBC(String input) {
        return StringHelper.toDBC(input, null);
    }

    public static String toDBC(String text, Set<Character> notConvertSet) {
        char[] chars = text.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (null != notConvertSet && notConvertSet.contains(Character.valueOf(chars[i]))) continue;
            if (chars[i] == '\u3000') {
                chars[i] = 32;
                continue;
            }
            if (chars[i] <= '\uff00' || chars[i] >= '\uff5f') continue;
            chars[i] = (char)(chars[i] - 65248);
        }
        return new String(chars);
    }

    public static String[] split(String toSplit, String delimiter) {
        return StringUtils.tokenizeToStringArray((String)toSplit, (String)delimiter);
    }

    public static String capitalize(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            char firstChar = str.charAt(0);
            return Character.isTitleCase(firstChar) ? str : Character.toTitleCase(firstChar) + str.substring(1);
        }
        return str;
    }

    public static String uncapitalize(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            char firstChar = str.charAt(0);
            return Character.isLowerCase(firstChar) ? str : Character.toLowerCase(firstChar) + str.substring(1);
        }
        return str;
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringHelper.replace(text, searchString, replacement, -1);
    }

    public static String replace(String text, String searchString, String replacement, int max) {
        if (!StringHelper.isEmpty(text) && !StringHelper.isEmpty(searchString) && replacement != null && max != 0) {
            int start = 0;
            int end = text.indexOf(searchString, start);
            if (end == -1) {
                return text;
            }
            int replLength = searchString.length();
            int increase = replacement.length() - replLength;
            int n = increase = increase < 0 ? 0 : increase;
            StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
            while (end != -1) {
                buf.append(text, start, end).append(replacement);
                start = end + replLength;
                if (--max == 0) break;
                end = text.indexOf(searchString, start);
            }
            buf.append(text.substring(start));
            return buf.toString();
        }
        return text;
    }

    public static String substringBetween(String str, String tag) {
        return StringHelper.substringBetween(str, tag, tag);
    }

    public static String substringBetween(String str, String open, String close) {
        if (str != null && open != null && close != null) {
            int end;
            int start = str.indexOf(open);
            if (start != -1 && (end = str.indexOf(close, start + open.length())) != -1) {
                return str.substring(start + open.length(), end);
            }
            return null;
        }
        return null;
    }

    public static int indexOf(CharSequence seq, CharSequence searchSeq) {
        return seq != null && searchSeq != null ? seq.toString().indexOf(searchSeq.toString()) : -1;
    }

    public static String substringBefore(String str, String separator) {
        if (!StringHelper.isEmpty(str) && separator != null) {
            if (separator.isEmpty()) {
                return "";
            }
            int pos = str.indexOf(separator);
            return pos == -1 ? str : str.substring(0, pos);
        }
        return str;
    }

    public static String replaceAllWithRegex(String text, String regex, String replacement) {
        return text != null && regex != null && replacement != null ? text.replaceAll(regex, replacement) : text;
    }

    public static boolean equals(CharSequence cs1, CharSequence cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 != null && cs2 != null) {
            return cs1 instanceof String && cs2 instanceof String ? cs1.equals(cs2) : StringHelper.regionMatches(cs1, false, 0, cs2, 0, Math.max(cs1.length(), cs2.length()));
        }
        return false;
    }

    public static void main(String[] args) {
        String[] p;
        String a = "0,c56430f000b3400fafb8ff75c0bc0add,d6538cb6d2d94016ad32196f68234b9b,";
        for (String pp : p = StringHelper.split(a, ",")) {
            System.out.println(pp);
        }
    }
}

