/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.license.bean.response;

import com.tongweb.commons.license.bean.response.ResultCodeEnum;
import java.io.Serializable;

public class Response<T>
implements Serializable {
    private static final long serialVersionUID = -3970205051591210082L;
    private boolean result = false;
    private int code;
    private String message;
    private T params;

    public Response() {
        this.result = true;
    }

    public Response(boolean isResult, int code, String message, T t) {
        this.result = isResult;
        this.params = t;
        this.code = code;
        this.message = message;
    }

    public Response(boolean result, ResultCodeEnum resultType) {
        this.result = result;
        this.code = resultType.getCode();
        this.message = resultType.toString();
    }

    public Response(boolean result, int code) {
        this.result = result;
        this.code = code;
        this.message = ResultCodeEnum.indexValue(code);
    }

    public Response(T t) {
        this.result = true;
        this.code = ResultCodeEnum.SUCCESS.getCode();
        this.message = ResultCodeEnum.SUCCESS.toString();
        this.params = t;
    }

    public Response(boolean result, int code, String message) {
        this.result = result;
        this.code = code;
        this.message = message;
    }

    public Response(Response response) {
        this.result = response.result;
        this.code = response.code;
        this.message = response.message;
    }

    public boolean isResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public T getParams() {
        return this.params;
    }

    public void setParams(T params) {
        this.params = params;
    }

    public String toString() {
        return "Response{result=" + this.result + ", code=" + this.code + ", message='" + this.message + '\'' + ", params=" + this.params + '}';
    }
}

