/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.springframework.boot.loader.jar.JarFile;

public class ClashPreventUtils {
    private static Set<JarEntry> parentdepJars = new HashSet<JarEntry>();
    private static Map<String, GavInfo> gavInfos = new HashMap<String, GavInfo>();
    private static Map<String, HashSet<String>> conflictJars = new HashMap<String, HashSet<String>>();
    private static Map<String, String> classList = new HashMap<String, String>();
    private static Map<String, HashSet<String>> conflictClasses = new HashMap<String, HashSet<String>>();

    public static void check() throws Exception {
        String conflictJarList = null;
        try {
            String parentJarPath = ClashPreventUtils.class.getClassLoader().getResource("").getPath().split("!")[0];
            if (parentJarPath.startsWith("file:/")) {
                String[] paths = parentJarPath.split("/");
                parentJarPath = "./" + paths[paths.length - 1];
            }
            JarFile jar = new JarFile(new File(parentJarPath));
            ClashPreventUtils.checkJar(jar);
            if (conflictJars.size() == 0) {
                return;
            }
            conflictJarList = "\nThe following jars may have conflicts, please check:\n";
            Set<String> JarskeySet = conflictJars.keySet();
            for (String jarName : JarskeySet) {
                HashSet<String> jarTempList = conflictJars.get(jarName);
                for (String jarTemp : jarTempList) {
                    conflictJarList = conflictJarList + jarTemp + "\n";
                }
                conflictJarList = conflictJarList + "\n";
            }
        }
        catch (Exception parentJarPath) {
        }
        catch (Error error) {
            return;
        }
        if (conflictJarList != null) {
            throw new Exception(conflictJarList);
        }
    }

    public static void checkJar(JarFile jar) throws Exception {
        try {
            Enumeration innerFiles = jar.entries();
            ArrayList<JarFile> depJars = new ArrayList<JarFile>();
            while (innerFiles.hasMoreElements()) {
                JarEntry jarEntryTemp = (JarEntry)innerFiles.nextElement();
                if (!jarEntryTemp.getName().endsWith(".jar")) continue;
                depJars.add(jar.getNestedJarFile((ZipEntry)jarEntryTemp));
            }
            if (depJars.size() != 0) {
                for (JarFile jarFileTemp : depJars) {
                    ClashPreventUtils.checkJar(jarFileTemp);
                }
            }
            for (JarFile depjar : depJars) {
                ClashPreventUtils.getGAV(depjar);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void getGAV(JarFile jar) throws Exception {
        try {
            GavInfo gavInfo = new GavInfo();
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                return;
            }
            Attributes attributes = jar.getManifest().getMainAttributes();
            Set<Object> set = attributes.keySet();
            Object groupIdKey = null;
            Object artifactIdKey = null;
            Object versionKey = null;
            for (Object o2 : set) {
                if ("Implementation-Vendor-Id".equals(o2.toString())) {
                    groupIdKey = o2;
                }
                if ("Implementation-Title".equals(o2.toString())) {
                    artifactIdKey = o2;
                }
                if (!"Implementation-Version".equals(o2.toString())) continue;
                versionKey = o2;
            }
            Object groupId = attributes.get(groupIdKey);
            Object artifactId = attributes.get(artifactIdKey);
            Object version = attributes.get(versionKey);
            if (groupId != null) {
                gavInfo.setGroupId(groupId.toString());
            }
            if (artifactId != null) {
                gavInfo.setArtifactId(artifactId.toString());
            }
            if (version != null) {
                gavInfo.setVersion(version.toString());
            }
            gavInfo.setJarFile(jar);
            if (groupId != null && artifactId != null) {
                String key = groupId + "-" + artifactId;
                if (gavInfos.containsKey(key)) {
                    String existJarName;
                    HashSet<String> conflictJar = conflictJars.get(key);
                    if (conflictJar == null) {
                        conflictJar = new HashSet();
                    }
                    if (!(existJarName = gavInfos.get(key).getJarFile().getName()).equals(jar.getName())) {
                        conflictJar.add(jar.getName());
                        conflictJar.add(existJarName);
                        conflictJars.put(key, conflictJar);
                    }
                }
                gavInfos.put(key, gavInfo);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static class GavInfo {
        private String groupId;
        private String artifactId;
        private String version;
        private JarFile jarFile;

        GavInfo() {
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public JarFile getJarFile() {
            return this.jarFile;
        }

        public void setJarFile(JarFile jarFile) {
            this.jarFile = jarFile;
        }

        public String toString() {
            return "GavInfo:{groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + '}';
        }
    }
}

