/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.common.request;

import com.tongtech.tfw.backend.common.request.RequestWrapper;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.PathMatcher;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;
import org.springframework.web.util.UrlPathHelper;

public class RequestFilter
implements Filter {
    @Autowired
    private UrlPathHelper urlPathHelper;
    @Autowired
    private PathMatcher pathMatcher;
    @Value(value="${tfw.request.ignore}")
    List<String> ignoreList;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String requestUri = this.urlPathHelper.getOriginatingRequestUri(httpRequest);
        for (String ignores : this.ignoreList) {
            if (!this.pathMatcher.match(ignores, requestUri)) continue;
            chain.doFilter(request, response);
            return;
        }
        StandardServletMultipartResolver commonsMultipartResolver = new StandardServletMultipartResolver();
        if (!commonsMultipartResolver.isMultipart(httpRequest)) {
            request = new RequestWrapper((HttpServletRequest)request);
        }
        String requestId = IdHelper.getId24bit();
        MDC.put((String)"requestId", (String)requestId);
        request.setAttribute("requestId", (Object)requestId);
        request.setAttribute("startTime", (Object)System.nanoTime());
        request.setAttribute("url", (Object)requestUri);
        String method = httpRequest.getMethod();
        request.setAttribute("method", (Object)method);
        chain.doFilter(request, response);
    }

    public void destroy() {
        MDC.remove((String)"requestId");
    }
}

