/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.common.request;

import com.tongtech.tfw.backend.common.request.RequestUtil;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.util.ObjectUtils;

public class RequestWrapper
extends HttpServletRequestWrapper {
    private final byte[] requestBodyBuffer;
    private final Map<String, String[]> parameterMap;

    public RequestWrapper(HttpServletRequest request) {
        super(request);
        this.parameterMap = request.getParameterMap();
        this.requestBodyBuffer = RequestUtil.getByteBody(request);
    }

    public BufferedReader getReader() {
        ServletInputStream inputStream = this.getInputStream();
        return ObjectHelper.isEmpty((Object)inputStream) ? null : new BufferedReader(new InputStreamReader((InputStream)inputStream));
    }

    public ServletInputStream getInputStream() {
        if (ObjectUtils.isEmpty((Object)this.requestBodyBuffer)) {
            return null;
        }
        final ByteArrayInputStream bais = new ByteArrayInputStream(this.requestBodyBuffer);
        return new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() {
                return bais.read();
            }
        };
    }
}

