/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.common.response;

import com.tongtech.tfw.backend.common.constants.enumeration.ApiStatusCodeEnum;
import com.tongtech.tfw.backend.common.constants.enumeration.HttpStatusCodeEnum;
import com.tongtech.tfw.backend.common.log.HttpCallLogHelper;
import com.tongtech.tfw.backend.common.models.response.FailedResponse;
import com.tongtech.tfw.backend.common.models.response.ResponseInfo;
import com.tongtech.tfw.backend.common.models.response.SuccessResponse;
import com.tongtech.tfw.backend.common.response.ResponseWrapper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResponseUtil {
    public static void response(HttpServletRequest request, HttpServletResponse response, ApiStatusCodeEnum apiStatusCodeEnum, Exception exception) {
        ResponseUtil.response(request, response, ResponseInfo.transformApiStatus(apiStatusCodeEnum), exception);
    }

    public static void response(HttpServletRequest request, HttpServletResponse response, ApiStatusCodeEnum apiStatusCodeEnum, Object resultObject) {
        ResponseUtil.response(request, response, ResponseInfo.transformApiStatus(apiStatusCodeEnum), resultObject);
    }

    public static void response(HttpServletRequest request, HttpServletResponse response, HttpStatusCodeEnum httpStatusCodeEnum, Exception exception) {
        ResponseUtil.response(request, response, ResponseInfo.transformHttpStatus(httpStatusCodeEnum), exception);
    }

    public static void response(HttpServletRequest request, HttpServletResponse response, HttpStatusCodeEnum httpStatusCodeEnum, Object result) {
        ResponseUtil.response(request, response, ResponseInfo.transformHttpStatus(httpStatusCodeEnum), result);
    }

    public static void response(HttpServletRequest request, HttpServletResponse response, ResponseInfo httpStatusInfo, Object resultObject) {
        ResponseUtil.response(request, new ResponseWrapper(response), SuccessResponse.buildSuccessResponse(request, httpStatusInfo, resultObject));
    }

    public static void response(HttpServletRequest request, HttpServletResponse response, ResponseInfo httpStatusInfo, Exception exception) {
        ResponseUtil.response(request, new ResponseWrapper(response), FailedResponse.buildFailedResponse(request, exception, httpStatusInfo));
    }

    public static void response(HttpServletRequest request, ResponseWrapper response, Object result) {
        HttpCallLogHelper.printHttpCallLogInfo(request, response, result);
        if (ObjectHelper.isNotEmpty((Object)((Object)response))) {
            response.writeJsonResponse(result);
        }
        HttpCallLogHelper.logRecord(request, response, result);
    }
}

