/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.workflow.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tongtech.tfw.backend.core.models.exceptions.FrameworkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app"})
public class FlowableStencilSetResource {
    private static final Logger log = LoggerFactory.getLogger(FlowableStencilSetResource.class);
    @Autowired
    protected ObjectMapper objectMapper;

    @RequestMapping(value={"/rest/stencil-sets/editor"}, method={RequestMethod.GET}, produces={"application/json"})
    public JsonNode getStencilSetForEditor() {
        try {
            JsonNode stencilNode = this.objectMapper.readTree(this.getClass().getClassLoader().getResourceAsStream("stencilset/zh/stencilset_bpmn.json"));
            return stencilNode;
        }
        catch (Exception e) {
            log.error("Error reading bpmn stencil set json", (Throwable)e);
            throw new FrameworkException("Error reading bpmn stencil set json");
        }
    }

    @RequestMapping(value={"/rest/stencil-sets/cmmneditor"}, method={RequestMethod.GET}, produces={"application/json"})
    public JsonNode getCmmnStencilSetForEditor() {
        try {
            JsonNode stencilNode = this.objectMapper.readTree(this.getClass().getClassLoader().getResourceAsStream("stencilset/zh/stencilset_cmmn.json"));
            return stencilNode;
        }
        catch (Exception e) {
            log.error("Error reading bpmn stencil set json", (Throwable)e);
            throw new FrameworkException("Error reading bpmn stencil set json");
        }
    }
}

