/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.commons.license.socket;

import com.tongtech.commons.license.socket.Message;
import com.tongtech.commons.license.socket.MessageType;
import com.tongtech.commons.license.socket.TopicHandler;
import com.tongtech.commons.license.socket.a.c;
import com.tongtech.commons.license.utils.i;
import com.tongtech.commons.license.utils.m;
import com.tongtech.miniws.handshake.ServerHandshake;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLParameters;

public class MessageHandler {
    private final HashMap topicStrategyRouter = new HashMap();
    private static final Logger log = Logger.getLogger(MessageHandler.class.getName());
    private static MessageHandler instance;
    private c miniWsApi;
    private final i reductionLog = new i(101);

    public static MessageHandler getInstance() {
        if (instance == null) {
            instance = new MessageHandler();
        }
        return instance;
    }

    public static void disconnection() {
        MessageHandler.instance.miniWsApi = null;
        instance = null;
    }

    public void init(c miniWsApi) {
        this.miniWsApi = miniWsApi;
    }

    public void handleMessage(String msgContent) {
        Message message = (Message)m.a(msgContent, Message.class);
        MessageType messageType = MessageType.getMessageType(message.getType());
        ((TopicHandler)this.topicStrategyRouter.get(messageType.getType())).doOnMessage(message);
    }

    public void handleOnOpen(ServerHandshake serverHandshake) {
        log.fine("license websocket open");
    }

    public void handleOnClose(int i2, String s2, boolean b2) {
        boolean isReductionLog = this.reductionLog.a();
        if (isReductionLog) {
            log.info("license websocket connection onclose...");
        }
        if (this.miniWsApi.f()) {
            log.fine(" onclose but client is busy ");
            return;
        }
        this.miniWsApi.g();
        this.miniWsApi.b();
    }

    public void handleOnError(Exception e2) {
        boolean isReductionLog = this.reductionLog.a();
        if (isReductionLog) {
            log.log(Level.INFO, "do license websocket retry connect, case by: " + e2.getMessage());
        }
    }

    public void handleOnSetSSLParameters(SSLParameters sslParameters) {
    }

    public HashMap getTopicStrategyRouter() {
        return (HashMap)this.topicStrategyRouter.clone();
    }

    public void registerTopicStrategy(MessageType type, TopicHandler topicStrategy) {
        this.topicStrategyRouter.put(type.getType(), topicStrategy);
    }
}

