/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.commons.license.socket;

import com.tongtech.commons.license.socket.Message;
import com.tongtech.commons.license.socket.MessageHandler;
import com.tongtech.commons.license.socket.a.c;
import com.tongtech.commons.license.utils.EnvConfigEnum;
import com.tongtech.commons.license.utils.cipher.MultiJDKBase64Util;
import com.tongtech.miniws.enums.ReadyState;
import com.tongtech.miniws.framing.PongFrame;
import com.tongweb.commons.license.bean.cfg.LicenseConfig;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebSocketApiAdapter {
    private static final Logger logger = Logger.getLogger(WebSocketApiAdapter.class.getName());
    private String clientId;
    private LicenseConfig cfg;
    private c miniWsApi = new c();

    public WebSocketApiAdapter() {
        MessageHandler.getInstance().init(this.miniWsApi);
    }

    public void checkConfig(List hosts) {
        assert (this.cfg.getLicenseIps() != null);
        assert (!this.cfg.getLicenseIps().trim().isEmpty());
        for (String host : hosts) {
            this.miniWsApi.b(this.getWebSocketAddress(host));
        }
    }

    public String getWebSocketAddress(String host) {
        if (!host.toUpperCase().contains("HTTP") && !host.toUpperCase().contains("HTTPS")) {
            host = "http://" + host;
        }
        host = host.replace("http", "ws").replace("https", "wss");
        String contextPath = EnvConfigEnum.LICENSE_CONTEXT_PATH.getConfigProperty();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getWebSocketAddress contextPath:" + contextPath);
        }
        return host + contextPath + "/ws/container/licenseserver?clientId=" + this.clientId + "&productKey=" + this.cfg.getProductKey() + "&licenseId=" + this.cfg.getLicenseId();
    }

    public boolean sendMsg(Message message) {
        return this.miniWsApi.a(message);
    }

    @Deprecated
    public String getWSHost(String host) {
        if (!host.toUpperCase().contains("HTTP") && !host.toUpperCase().contains("HTTPS")) {
            host = "http://" + host;
        }
        return host.replace("http", "ws").replace("https", "wss");
    }

    public void disconnection() {
        this.miniWsApi.e();
        this.miniWsApi = null;
        MessageHandler.disconnection();
    }

    public void config(LicenseConfig config) {
        this.cfg = config;
        this.miniWsApi.a(config);
    }

    public void reFlushUrl(String host) {
        String address = this.getWebSocketAddress(host);
        this.miniWsApi.a(address);
    }

    public void setRsaClientId(String rsaClientId) {
        this.clientId = MultiJDKBase64Util.encode(rsaClientId.getBytes(StandardCharsets.UTF_8));
    }

    public void pong(String topAddress) {
        this.miniWsApi.a(new PongFrame());
    }

    public ReadyState getReadyState() {
        return this.miniWsApi.h();
    }

    public void init() {
        this.miniWsApi.a();
    }
}

