/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.backend.admin.apis.biz.tool.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.admin.apis.biz.tool.model.domain.FormGen;
import com.tongtech.tfw.backend.admin.apis.biz.tool.model.dto.FormGenDelParam;
import com.tongtech.tfw.backend.admin.apis.biz.tool.model.dto.FormGenParam;
import com.tongtech.tfw.backend.admin.apis.biz.tool.model.dto.FormGenResponse;
import com.tongtech.tfw.backend.admin.apis.biz.tool.service.FormGenService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tool/form"})
@Api(value="FormGen", tags={"FormGen \u8868\u5355\u751f\u6210"})
public class FormGenController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(FormGenController.class);
    @Autowired
    private FormGenService formGenService;

    @ApiOperation(value="\u65b0\u589e \u8868\u5355\u751f\u6210", notes="\u65b0\u589e \u8868\u5355\u751f\u6210 Add FormGen")
    @PostMapping(value={"/add"})
    public BaseResponse<FormGen> addEntity(@RequestBody FormGen addRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)((Object)addRequest))) {
            String id = IdHelper.getId32bit();
            FormGen data = (FormGen)((Object)BeanHelper.beanToBean((Object)((Object)addRequest), FormGen.class));
            data.setId(id);
            boolean result = this.formGenService.save((Object)data);
            if (result) {
                FormGen newEntity = new FormGen();
                newEntity.setId(id);
                baseResponse.setData((Object)newEntity);
            }
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u8868\u5355\u751f\u6210 ", notes="\u83b7\u53d6 \u8868\u5355\u751f\u6210 Get FormGen By Id")
    @GetMapping(value={"/get"})
    public BaseResponse<FormGen> getById(String id) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)id)) {
            FormGen data = (FormGen)((Object)this.formGenService.getById((Serializable)((Object)id)));
            baseResponse.setData((Object)data);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539 \u8868\u5355\u751f\u6210 ", notes="\u4fee\u6539 \u8868\u5355\u751f\u6210 Update FormGen By Id")
    @PutMapping(value={"/update"})
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody FormGen updateRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)((Object)updateRequest)) && StringHelper.isNotEmpty((CharSequence)updateRequest.getId())) {
            FormGen data = (FormGen)((Object)BeanHelper.beanToBean((Object)((Object)updateRequest), FormGen.class));
            data.setUpdateBy(this.getUserId());
            data.setUpdateDate(LocalDateTime.now());
            boolean result = this.formGenService.updateById((Object)data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5220\u9664 \u8868\u5355\u751f\u6210 ", notes="\u5220\u9664 \u8868\u5355\u751f\u6210 delete FormGen By Id")
    @PutMapping(value={"/delete"})
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody FormGenDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && StringHelper.isNotEmpty((CharSequence)deleteRequest.getId())) {
            FormGen data = new FormGen();
            data.setId(deleteRequest.getId());
            data.setStatus("1");
            boolean result = this.formGenService.updateById((Object)data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8868\u5355\u751f\u6210", notes="\u6279\u91cf\u5220\u9664\u8868\u5355\u751f\u6210 delete FormGen by batch Id")
    @PutMapping(value={"/batch_delete"})
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(@RequestBody FormGenDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && !deleteRequest.getIds().isEmpty()) {
            ArrayList<FormGen> formGenList = new ArrayList<FormGen>();
            for (String id : deleteRequest.getIds()) {
                FormGen data = new FormGen();
                data.setId(id);
                data.setStatus("1");
                formGenList.add(data);
            }
            boolean result = this.formGenService.updateBatchById(formGenList);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u8868\u5355\u751f\u6210 \u5206\u9875\u5217\u8868", notes="\u83b7\u53d6 \u8868\u5355\u751f\u6210 \u5206\u9875\u5217\u8868 List FormGen with page")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<FormGenResponse>> listEntity(FormGenParam param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<FormGen> queryWrapper = this.createQuery(param);
        Page resultList = (Page)this.formGenService.page((IPage)resultPage, (Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords().stream().map(e -> (FormGenResponse)e.beanToBean(FormGenResponse.class)).collect(Collectors.toList()));
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u8868\u5355\u751f\u6210 \u5217\u8868", notes="\u83b7\u53d6 \u8868\u5355\u751f\u6210 \u5217\u8868 List FormGen all")
    @GetMapping(value={"/datas"})
    public BaseResponse<BaseResponseList<FormGenResponse>> listAllEntity(FormGenParam param) {
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper<FormGen> queryWrapper = this.createQuery(param);
        List resultList = this.formGenService.list((Wrapper)queryWrapper).stream().map(e -> (FormGenResponse)e.beanToBean(FormGenResponse.class)).collect(Collectors.toList());
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal((long)resultList.size());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    private QueryWrapper<FormGen> createQuery(FormGenParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getName())) {
            queryWrapper.like((Object)"name", (Object)queryParam.getName());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getCode())) {
            queryWrapper.eq((Object)"code", (Object)queryParam.getCode());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getType())) {
            queryWrapper.eq((Object)"type", (Object)queryParam.getType());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getForm())) {
            queryWrapper.eq((Object)"form", (Object)queryParam.getForm());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getManagePage())) {
            queryWrapper.eq((Object)"manage_page", (Object)queryParam.getManagePage());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getRouter())) {
            queryWrapper.eq((Object)"router", (Object)queryParam.getRouter());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getApi())) {
            queryWrapper.eq((Object)"api", (Object)queryParam.getApi());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        } else {
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc((Object)"update_date");
        }
        return queryWrapper;
    }
}

