/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.monitor.core.instrument.simple;

import com.tongweb.commons.monitor.core.instrument.AbstractDistributionSummary;
import com.tongweb.commons.monitor.core.instrument.AbstractTimer;
import com.tongweb.commons.monitor.core.instrument.Clock;
import com.tongweb.commons.monitor.core.instrument.Counter;
import com.tongweb.commons.monitor.core.instrument.DistributionSummary;
import com.tongweb.commons.monitor.core.instrument.FunctionCounter;
import com.tongweb.commons.monitor.core.instrument.FunctionTimer;
import com.tongweb.commons.monitor.core.instrument.Gauge;
import com.tongweb.commons.monitor.core.instrument.LongTaskTimer;
import com.tongweb.commons.monitor.core.instrument.Measurement;
import com.tongweb.commons.monitor.core.instrument.Meter;
import com.tongweb.commons.monitor.core.instrument.MeterRegistry;
import com.tongweb.commons.monitor.core.instrument.Timer;
import com.tongweb.commons.monitor.core.instrument.cumulative.CumulativeCounter;
import com.tongweb.commons.monitor.core.instrument.cumulative.CumulativeDistributionSummary;
import com.tongweb.commons.monitor.core.instrument.cumulative.CumulativeFunctionCounter;
import com.tongweb.commons.monitor.core.instrument.cumulative.CumulativeFunctionTimer;
import com.tongweb.commons.monitor.core.instrument.cumulative.CumulativeTimer;
import com.tongweb.commons.monitor.core.instrument.distribution.DistributionStatisticConfig;
import com.tongweb.commons.monitor.core.instrument.distribution.HistogramGauges;
import com.tongweb.commons.monitor.core.instrument.distribution.pause.PauseDetector;
import com.tongweb.commons.monitor.core.instrument.internal.DefaultGauge;
import com.tongweb.commons.monitor.core.instrument.internal.DefaultLongTaskTimer;
import com.tongweb.commons.monitor.core.instrument.internal.DefaultMeter;
import com.tongweb.commons.monitor.core.instrument.simple.SimpleConfig;
import com.tongweb.commons.monitor.core.instrument.step.StepCounter;
import com.tongweb.commons.monitor.core.instrument.step.StepDistributionSummary;
import com.tongweb.commons.monitor.core.instrument.step.StepFunctionCounter;
import com.tongweb.commons.monitor.core.instrument.step.StepFunctionTimer;
import com.tongweb.commons.monitor.core.instrument.step.StepTimer;
import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;

public class SimpleMeterRegistry
extends MeterRegistry {
    private final SimpleConfig config;

    public SimpleMeterRegistry() {
        this(SimpleConfig.DEFAULT, Clock.SYSTEM);
    }

    public SimpleMeterRegistry(SimpleConfig config, Clock clock) {
        super(clock);
        config.requireValid();
        this.config = config;
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        AbstractDistributionSummary summary;
        DistributionStatisticConfig merged = distributionStatisticConfig.merge(DistributionStatisticConfig.builder().expiry(this.config.step()).build());
        switch (this.config.mode()) {
            case CUMULATIVE: {
                summary = new CumulativeDistributionSummary(id, this.clock, merged, scale, false);
                break;
            }
            default: {
                summary = new StepDistributionSummary(id, this.clock, merged, scale, this.config.step().toMillis(), false);
            }
        }
        HistogramGauges.registerWithCommonFormat(summary, (MeterRegistry)this);
        return summary;
    }

    @Override
    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return new DefaultMeter(id, type, measurements);
    }

    @Override
    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        AbstractTimer timer;
        DistributionStatisticConfig merged = distributionStatisticConfig.merge(DistributionStatisticConfig.builder().expiry(this.config.step()).build());
        switch (this.config.mode()) {
            case CUMULATIVE: {
                timer = new CumulativeTimer(id, this.clock, merged, pauseDetector, this.getBaseTimeUnit(), false);
                break;
            }
            default: {
                timer = new StepTimer(id, this.clock, merged, pauseDetector, this.getBaseTimeUnit(), this.config.step().toMillis(), false);
            }
        }
        HistogramGauges.registerWithCommonFormat(timer, (MeterRegistry)this);
        return timer;
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, T obj, ToDoubleFunction<T> valueFunction) {
        return new DefaultGauge<T>(id, obj, valueFunction);
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        switch (this.config.mode()) {
            case CUMULATIVE: {
                return new CumulativeCounter(id);
            }
        }
        return new StepCounter(id, this.clock, this.config.step().toMillis());
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        DefaultLongTaskTimer ltt = new DefaultLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig, false);
        HistogramGauges.registerWithCommonFormat(ltt, (MeterRegistry)this);
        return ltt;
    }

    @Override
    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        switch (this.config.mode()) {
            case CUMULATIVE: {
                return new CumulativeFunctionTimer<T>(id, obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
            }
        }
        return new StepFunctionTimer<T>(id, this.clock, this.config.step().toMillis(), obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
    }

    @Override
    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        switch (this.config.mode()) {
            case CUMULATIVE: {
                return new CumulativeFunctionCounter<T>(id, obj, countFunction);
            }
        }
        return new StepFunctionCounter<T>(id, this.clock, this.config.step().toMillis(), obj, countFunction);
    }

    @Override
    protected TimeUnit getBaseTimeUnit() {
        return TimeUnit.SECONDS;
    }

    @Override
    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.config.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }
}

