/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.audit;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;

public class AuditLog {
    private static final Logger log = Logger.getLogger(AuditLog.class.getName());
    private String name = "audit.log";
    private Boolean enable = true;
    private String path;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private File targetDir;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getEnable() {
        return this.enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        this.path = path;
    }

    public void setTargetDir(File basedir) {
        this.targetDir = this.path == null || this.path.length() == 0 ? new File(basedir, this.name) : new File(this.path + File.separator + this.name);
    }

    public void start() {
        this.recordOperator("start");
    }

    public void stop() {
        this.recordOperator("stop");
    }

    public void recordOperator(String op) {
        Date now = new Date();
        String nowTime = this.sdf.format(now);
        String userName = System.getProperty("user.name");
        String message = nowTime + " " + userName + " " + op;
        this.write(message);
    }

    private void write(String message) {
        if (message != null && this.enable.booleanValue()) {
            if (!message.endsWith(System.getProperty("line.separator"))) {
                message = message + System.getProperty("line.separator");
            }
            try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(this.targetDir, true));){
                stream.write(message.getBytes());
                stream.flush();
            }
            catch (IOException e) {
                log.warning("write audit log to path:[" + this.targetDir.getAbsolutePath() + "] failed by " + e.getMessage());
            }
        }
    }
}

