/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.session;

import com.tongweb.container.LifecycleException;
import com.tongweb.container.LifecycleState;
import com.tongweb.container.Manager;
import com.tongweb.container.Store;
import com.tongweb.container.session.ManagerBase;
import com.tongweb.container.session.PersistentManagerBase;
import com.tongweb.container.session.StandardSession;
import com.tongweb.container.util.CustomObjectInputStream;
import com.tongweb.container.util.LifecycleBase;
import com.tongweb.container.util.ToStringUtil;
import com.tongweb.web.util.res.StringManager;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

public abstract class StoreBase
extends LifecycleBase
implements Store {
    protected static final String storeName = "StoreBase";
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected static final StringManager sm = StringManager.getManager(StoreBase.class);
    protected Manager manager;

    public String getStoreName() {
        return storeName;
    }

    @Override
    public void setManager(Manager manager) {
        Manager oldManager = this.manager;
        this.manager = manager;
        this.support.firePropertyChange("manager", oldManager, this.manager);
    }

    @Override
    public Manager getManager() {
        return this.manager;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String[] expiredKeys() throws IOException {
        return this.keys();
    }

    public void processExpires() {
        String[] keys = null;
        if (!this.getState().isAvailable()) {
            return;
        }
        try {
            keys = this.expiredKeys();
        }
        catch (IOException e) {
            this.manager.getContext().getLogger().error(sm.getString("store.keysFail"), e);
            return;
        }
        if (this.manager.getContext().getLogger().isTraceEnabled()) {
            this.manager.getContext().getLogger().trace(this.getStoreName() + ": processExpires check number of " + keys.length + " sessions");
        }
        long timeNow = System.currentTimeMillis();
        for (String key : keys) {
            try {
                int timeIdle;
                StandardSession session = (StandardSession)this.load(key);
                if (session == null || (timeIdle = (int)((timeNow - session.getThisAccessedTime()) / 1000L)) < session.getMaxInactiveInterval()) continue;
                if (this.manager.getContext().getLogger().isTraceEnabled()) {
                    this.manager.getContext().getLogger().trace(this.getStoreName() + ": processExpires expire store session " + key);
                }
                boolean isLoaded = false;
                if (this.manager instanceof PersistentManagerBase) {
                    isLoaded = ((PersistentManagerBase)this.manager).isLoaded(key);
                } else {
                    try {
                        if (this.manager.findSession(key) != null) {
                            isLoaded = true;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (isLoaded) {
                    session.recycle();
                } else {
                    session.expire();
                }
                this.remove(key);
            }
            catch (Exception e) {
                this.manager.getContext().getLogger().error(sm.getString("store.expireFail", key), e);
                try {
                    this.remove(key);
                }
                catch (IOException e2) {
                    this.manager.getContext().getLogger().error(sm.getString("store.removeFail", key), e2);
                }
            }
        }
    }

    protected ObjectInputStream getObjectInputStream(InputStream is) throws IOException {
        CustomObjectInputStream ois;
        BufferedInputStream bis = new BufferedInputStream(is);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (this.manager instanceof ManagerBase) {
            ManagerBase managerBase = (ManagerBase)this.manager;
            ois = new CustomObjectInputStream(bis, classLoader, this.manager.getContext().getLogger(), managerBase.getSessionAttributeValueClassNamePattern(), managerBase.getWarnOnSessionAttributeFilterFailure());
        } else {
            ois = new CustomObjectInputStream(bis, classLoader);
        }
        return ois;
    }

    @Override
    protected void initInternal() {
    }

    @Override
    protected void startInternal() throws LifecycleException {
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
    }

    @Override
    protected void destroyInternal() {
    }

    public String toString() {
        return ToStringUtil.toString((Object)this, this.manager);
    }
}

