/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.users;

import com.tongweb.container.Group;
import com.tongweb.container.Role;
import com.tongweb.container.User;
import com.tongweb.container.users.GenericGroup;
import com.tongweb.container.users.GenericRole;
import com.tongweb.container.users.GenericUser;
import com.tongweb.container.users.SparseUserDatabase;
import com.tongweb.juli.logging.Log;
import com.tongweb.juli.logging.LogFactory;
import com.tongweb.web.util.res.StringManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;

public class DataSourceUserDatabase
extends SparseUserDatabase {
    private static final Log log = LogFactory.getLog(DataSourceUserDatabase.class);
    private static final StringManager sm = StringManager.getManager(DataSourceUserDatabase.class);
    protected final DataSource dataSource;
    protected final String id;
    protected final ConcurrentHashMap<String, User> createdUsers = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, User> modifiedUsers = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, User> removedUsers = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Group> createdGroups = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Group> modifiedGroups = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Group> removedGroups = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Role> createdRoles = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Role> modifiedRoles = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Role> removedRoles = new ConcurrentHashMap();
    private String preparedAllUsers = null;
    private String preparedAllGroups = null;
    private String preparedAllRoles = null;
    private String preparedGroup = null;
    private String preparedRole = null;
    private String preparedUserRoles = null;
    private String preparedUser = null;
    private String preparedUserGroups = null;
    private String preparedGroupRoles = null;
    protected String dataSourceName = null;
    protected String roleNameCol = null;
    protected String roleAndGroupDescriptionCol = null;
    protected String groupNameCol = null;
    protected String userCredCol = null;
    protected String userFullNameCol = null;
    protected String userNameCol = null;
    protected String userRoleTable = null;
    protected String userGroupTable = null;
    protected String groupRoleTable = null;
    protected String userTable = null;
    protected String groupTable = null;
    protected String roleTable = null;
    private volatile boolean connectionSuccess = true;
    protected boolean readonly = true;
    private final ReentrantReadWriteLock dbLock = new ReentrantReadWriteLock();
    private final Lock dbReadLock = this.dbLock.readLock();
    private final Lock dbWriteLock = this.dbLock.writeLock();
    private final ReentrantReadWriteLock groupsLock = new ReentrantReadWriteLock();
    private final Lock groupsReadLock = this.groupsLock.readLock();
    private final Lock groupsWriteLock = this.groupsLock.writeLock();
    private final ReentrantReadWriteLock usersLock = new ReentrantReadWriteLock();
    private final Lock usersReadLock = this.usersLock.readLock();
    private final Lock usersWriteLock = this.usersLock.writeLock();
    private final ReentrantReadWriteLock rolesLock = new ReentrantReadWriteLock();
    private final Lock rolesReadLock = this.rolesLock.readLock();
    private final Lock rolesWriteLock = this.rolesLock.writeLock();

    public DataSourceUserDatabase(DataSource dataSource, String id) {
        this.dataSource = dataSource;
        this.id = id;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getRoleNameCol() {
        return this.roleNameCol;
    }

    public void setRoleNameCol(String roleNameCol) {
        this.roleNameCol = roleNameCol;
    }

    public String getUserCredCol() {
        return this.userCredCol;
    }

    public void setUserCredCol(String userCredCol) {
        this.userCredCol = userCredCol;
    }

    public String getUserNameCol() {
        return this.userNameCol;
    }

    public void setUserNameCol(String userNameCol) {
        this.userNameCol = userNameCol;
    }

    public String getUserRoleTable() {
        return this.userRoleTable;
    }

    public void setUserRoleTable(String userRoleTable) {
        this.userRoleTable = userRoleTable;
    }

    public String getUserTable() {
        return this.userTable;
    }

    public void setUserTable(String userTable) {
        this.userTable = userTable;
    }

    public String getRoleAndGroupDescriptionCol() {
        return this.roleAndGroupDescriptionCol;
    }

    public void setRoleAndGroupDescriptionCol(String roleAndGroupDescriptionCol) {
        this.roleAndGroupDescriptionCol = roleAndGroupDescriptionCol;
    }

    public String getGroupNameCol() {
        return this.groupNameCol;
    }

    public void setGroupNameCol(String groupNameCol) {
        this.groupNameCol = groupNameCol;
    }

    public String getUserFullNameCol() {
        return this.userFullNameCol;
    }

    public void setUserFullNameCol(String userFullNameCol) {
        this.userFullNameCol = userFullNameCol;
    }

    public String getUserGroupTable() {
        return this.userGroupTable;
    }

    public void setUserGroupTable(String userGroupTable) {
        this.userGroupTable = userGroupTable;
    }

    public String getGroupRoleTable() {
        return this.groupRoleTable;
    }

    public void setGroupRoleTable(String groupRoleTable) {
        this.groupRoleTable = groupRoleTable;
    }

    public String getGroupTable() {
        return this.groupTable;
    }

    public void setGroupTable(String groupTable) {
        this.groupTable = groupTable;
    }

    public String getRoleTable() {
        return this.roleTable;
    }

    public void setRoleTable(String roleTable) {
        this.roleTable = roleTable;
    }

    public boolean getReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    @Override
    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Group> getGroups() {
        this.dbReadLock.lock();
        try {
            this.groupsReadLock.lock();
            try {
                HashMap<String, Group> groups;
                block45: {
                    groups = new HashMap<String, Group>();
                    groups.putAll(this.createdGroups);
                    groups.putAll(this.modifiedGroups);
                    try (Connection dbConnection = this.openConnection();){
                        if (dbConnection == null || this.preparedAllGroups == null) break block45;
                        try (PreparedStatement stmt = dbConnection.prepareStatement(this.preparedAllGroups);
                             ResultSet rs = stmt.executeQuery();){
                            while (rs.next()) {
                                Group group;
                                String groupName = rs.getString(1);
                                if (groupName == null || groups.containsKey(groupName) || this.removedGroups.containsKey(groupName) || (group = this.findGroupInternal(dbConnection, groupName)) == null) continue;
                                groups.put(groupName, group);
                            }
                        }
                    }
                    catch (SQLException e) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                    }
                }
                Iterator<Group> iterator = groups.values().iterator();
                this.groupsReadLock.unlock();
                return iterator;
            }
            catch (Throwable throwable) {
                this.groupsReadLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.dbReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Role> getRoles() {
        this.dbReadLock.lock();
        try {
            this.rolesReadLock.lock();
            try {
                HashMap<String, Role> roles;
                block45: {
                    roles = new HashMap<String, Role>();
                    roles.putAll(this.createdRoles);
                    roles.putAll(this.modifiedRoles);
                    try (Connection dbConnection = this.openConnection();){
                        if (dbConnection == null || this.preparedAllRoles == null) break block45;
                        try (PreparedStatement stmt = dbConnection.prepareStatement(this.preparedAllRoles);
                             ResultSet rs = stmt.executeQuery();){
                            while (rs.next()) {
                                Role role;
                                String roleName = rs.getString(1);
                                if (roleName == null || roles.containsKey(roleName) || this.removedRoles.containsKey(roleName) || (role = this.findRoleInternal(dbConnection, roleName)) == null) continue;
                                roles.put(roleName, role);
                            }
                        }
                    }
                    catch (SQLException e) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                    }
                }
                Iterator<Role> iterator = roles.values().iterator();
                this.rolesReadLock.unlock();
                return iterator;
            }
            catch (Throwable throwable) {
                this.rolesReadLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.dbReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<User> getUsers() {
        this.dbReadLock.lock();
        try {
            this.usersReadLock.lock();
            try {
                HashMap<String, User> users = new HashMap<String, User>();
                users.putAll(this.createdUsers);
                users.putAll(this.modifiedUsers);
                Connection dbConnection = this.openConnection();
                if (dbConnection != null) {
                    try (PreparedStatement stmt = dbConnection.prepareStatement(this.preparedAllUsers);
                         ResultSet rs = stmt.executeQuery();){
                        while (rs.next()) {
                            User user;
                            String userName = rs.getString(1);
                            if (userName == null || users.containsKey(userName) || this.removedUsers.containsKey(userName) || (user = this.findUserInternal(dbConnection, userName)) == null) continue;
                            users.put(userName, user);
                        }
                    }
                    catch (SQLException e) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                    }
                    finally {
                        this.closeConnection(dbConnection);
                    }
                }
                Iterator<User> iterator = users.values().iterator();
                this.usersReadLock.unlock();
                return iterator;
            }
            catch (Throwable throwable) {
                this.usersReadLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.dbReadLock.unlock();
        }
    }

    @Override
    public void close() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group createGroup(String groupname, String description) {
        this.dbReadLock.lock();
        try {
            this.groupsWriteLock.lock();
            try {
                GenericGroup<DataSourceUserDatabase> group = new GenericGroup<DataSourceUserDatabase>(this, groupname, description, null);
                this.createdGroups.put(groupname, group);
                this.modifiedGroups.remove(groupname);
                GenericGroup<DataSourceUserDatabase> genericGroup = group;
                this.groupsWriteLock.unlock();
                return genericGroup;
            }
            catch (Throwable throwable) {
                this.groupsWriteLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.dbReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Role createRole(String rolename, String description) {
        this.dbReadLock.lock();
        try {
            this.rolesWriteLock.lock();
            try {
                GenericRole<DataSourceUserDatabase> role = new GenericRole<DataSourceUserDatabase>(this, rolename, description);
                this.createdRoles.put(rolename, role);
                this.modifiedRoles.remove(rolename);
                GenericRole<DataSourceUserDatabase> genericRole = role;
                this.rolesWriteLock.unlock();
                return genericRole;
            }
            catch (Throwable throwable) {
                this.rolesWriteLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.dbReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User createUser(String username, String password, String fullName) {
        this.dbReadLock.lock();
        try {
            this.usersWriteLock.lock();
            try {
                GenericUser<DataSourceUserDatabase> user = new GenericUser<DataSourceUserDatabase>(this, username, password, fullName, null, null);
                this.createdUsers.put(username, user);
                this.modifiedUsers.remove(username);
                GenericUser<DataSourceUserDatabase> genericUser = user;
                this.usersWriteLock.unlock();
                return genericUser;
            }
            catch (Throwable throwable) {
                this.usersWriteLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.dbReadLock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Group findGroup(String groupname) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Group findGroupInternal(Connection dbConnection, String groupName) {
        GenericGroup<DataSourceUserDatabase> group;
        block54: {
            group = null;
            try (PreparedStatement stmt = dbConnection.prepareStatement(this.preparedGroup);){
                stmt.setString(1, groupName);
                try (ResultSet rs = stmt.executeQuery();){
                    if (!rs.next() || rs.getString(1) == null) break block54;
                    String description = this.roleAndGroupDescriptionCol != null ? rs.getString(2) : null;
                    ArrayList<Role> groupRoles = new ArrayList<Role>();
                    if (groupName != null) {
                        groupName = groupName.trim();
                        try (PreparedStatement stmt2 = dbConnection.prepareStatement(this.preparedGroupRoles);){
                            stmt2.setString(1, groupName);
                            try (ResultSet rs2 = stmt2.executeQuery();){
                                while (rs2.next()) {
                                    Role groupRole;
                                    String roleName = rs2.getString(1);
                                    if (roleName == null || (groupRole = this.findRoleInternal(dbConnection, roleName)) == null) continue;
                                    groupRoles.add(groupRole);
                                }
                            }
                        }
                        catch (SQLException e) {
                            log.error(sm.getString("dataSourceUserDatabase.exception"), e);
                        }
                    }
                    group = new GenericGroup<DataSourceUserDatabase>(this, groupName, description, groupRoles);
                }
            }
            catch (SQLException e) {
                log.error(sm.getString("dataSourceUserDatabase.exception"), e);
            }
        }
        return group;
    }

    /*
     * Exception decompiling
     */
    @Override
    public Role findRole(String rolename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Role findRoleInternal(Connection dbConnection, String roleName) {
        GenericRole<DataSourceUserDatabase> role = null;
        try (PreparedStatement stmt = dbConnection.prepareStatement(this.preparedRole);){
            stmt.setString(1, roleName);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next() && rs.getString(1) != null) {
                    String description = this.roleAndGroupDescriptionCol != null ? rs.getString(2) : null;
                    role = new GenericRole<DataSourceUserDatabase>(this, roleName, description);
                }
            }
        }
        catch (SQLException e) {
            log.error(sm.getString("dataSourceUserDatabase.exception"), e);
        }
        return role;
    }

    /*
     * Exception decompiling
     */
    @Override
    public User findUser(String username) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 10[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public User findUserInternal(Connection dbConnection, String userName) {
        Throwable throwable;
        Object rs;
        String dbCredentials = null;
        String fullName = null;
        try (PreparedStatement stmt = dbConnection.prepareStatement(this.preparedUser);){
            stmt.setString(1, userName);
            rs = stmt.executeQuery();
            throwable = null;
            try {
                if (rs.next()) {
                    dbCredentials = rs.getString(1);
                    if (this.userFullNameCol != null) {
                        fullName = rs.getString(2);
                    }
                }
                dbCredentials = dbCredentials != null ? dbCredentials.trim() : null;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rs != null) {
                    if (throwable != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            log.error(sm.getString("dataSourceUserDatabase.exception"), e);
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        if (this.isGroupStoreDefined()) {
            try {
                PreparedStatement stmt = dbConnection.prepareStatement(this.preparedUserGroups);
                rs = null;
                try {
                    stmt.setString(1, userName);
                    try (ResultSet rs2 = stmt.executeQuery();){
                        while (rs2.next()) {
                            Group group;
                            String groupName = rs2.getString(1);
                            if (groupName == null || (group = this.findGroupInternal(dbConnection, groupName)) == null) continue;
                            groups.add(group);
                        }
                    }
                }
                catch (Throwable throwable4) {
                    rs = throwable4;
                    throw throwable4;
                }
                finally {
                    if (stmt != null) {
                        if (rs != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable5) {
                                ((Throwable)rs).addSuppressed(throwable5);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                log.error(sm.getString("dataSourceUserDatabase.exception"), e);
            }
        }
        ArrayList<Role> roles = new ArrayList<Role>();
        if (this.userRoleTable != null && this.roleNameCol != null) {
            try {
                throwable = null;
                try (PreparedStatement stmt = dbConnection.prepareStatement(this.preparedUserRoles);){
                    stmt.setString(1, userName);
                    try (ResultSet rs3 = stmt.executeQuery();){
                        while (rs3.next()) {
                            Role role;
                            String roleName = rs3.getString(1);
                            if (roleName == null || (role = this.findRoleInternal(dbConnection, roleName)) == null) continue;
                            roles.add(role);
                        }
                    }
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
            }
            catch (SQLException e) {
                log.error(sm.getString("dataSourceUserDatabase.exception"), e);
            }
        }
        GenericUser<DataSourceUserDatabase> user = new GenericUser<DataSourceUserDatabase>(this, userName, dbCredentials, fullName, groups, roles);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifiedGroup(Group group) {
        this.dbReadLock.lock();
        try {
            this.groupsWriteLock.lock();
            try {
                String name = group.getName();
                if (!this.createdGroups.containsKey(name) && !this.removedGroups.containsKey(name)) {
                    this.modifiedGroups.put(name, group);
                }
            }
            finally {
                this.groupsWriteLock.unlock();
            }
        }
        finally {
            this.dbReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifiedRole(Role role) {
        this.dbReadLock.lock();
        try {
            this.rolesWriteLock.lock();
            try {
                String name = role.getName();
                if (!this.createdRoles.containsKey(name) && !this.removedRoles.containsKey(name)) {
                    this.modifiedRoles.put(name, role);
                }
            }
            finally {
                this.rolesWriteLock.unlock();
            }
        }
        finally {
            this.dbReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifiedUser(User user) {
        this.dbReadLock.lock();
        try {
            this.usersWriteLock.lock();
            try {
                String name = user.getName();
                if (!this.createdUsers.containsKey(name) && !this.removedUsers.containsKey(name)) {
                    this.modifiedUsers.put(name, user);
                }
            }
            finally {
                this.usersWriteLock.unlock();
            }
        }
        finally {
            this.dbReadLock.unlock();
        }
    }

    @Override
    public void open() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("dataSourceUserDatabase.features", Boolean.toString(this.userRoleTable != null && this.roleNameCol != null), Boolean.toString(this.isRoleStoreDefined()), Boolean.toString(this.isGroupStoreDefined())));
        }
        this.dbWriteLock.lock();
        try {
            StringBuilder temp = new StringBuilder("SELECT ");
            temp.append(this.userCredCol);
            if (this.userFullNameCol != null) {
                temp.append(',').append(this.userFullNameCol);
            }
            temp.append(" FROM ");
            temp.append(this.userTable);
            temp.append(" WHERE ");
            temp.append(this.userNameCol);
            temp.append(" = ?");
            this.preparedUser = temp.toString();
            temp = new StringBuilder("SELECT ");
            temp.append(this.userNameCol);
            temp.append(" FROM ");
            temp.append(this.userTable);
            this.preparedAllUsers = temp.toString();
            temp = new StringBuilder("SELECT ");
            temp.append(this.roleNameCol);
            temp.append(" FROM ");
            temp.append(this.userRoleTable);
            temp.append(" WHERE ");
            temp.append(this.userNameCol);
            temp.append(" = ?");
            this.preparedUserRoles = temp.toString();
            if (this.isGroupStoreDefined()) {
                temp = new StringBuilder("SELECT ");
                temp.append(this.groupNameCol);
                temp.append(" FROM ");
                temp.append(this.userGroupTable);
                temp.append(" WHERE ");
                temp.append(this.userNameCol);
                temp.append(" = ?");
                this.preparedUserGroups = temp.toString();
                temp = new StringBuilder("SELECT ");
                temp.append(this.roleNameCol);
                temp.append(" FROM ");
                temp.append(this.groupRoleTable);
                temp.append(" WHERE ");
                temp.append(this.groupNameCol);
                temp.append(" = ?");
                this.preparedGroupRoles = temp.toString();
                temp = new StringBuilder("SELECT ");
                temp.append(this.groupNameCol);
                if (this.roleAndGroupDescriptionCol != null) {
                    temp.append(',').append(this.roleAndGroupDescriptionCol);
                }
                temp.append(" FROM ");
                temp.append(this.groupTable);
                temp.append(" WHERE ");
                temp.append(this.groupNameCol);
                temp.append(" = ?");
                this.preparedGroup = temp.toString();
                temp = new StringBuilder("SELECT ");
                temp.append(this.groupNameCol);
                temp.append(" FROM ");
                temp.append(this.groupTable);
                this.preparedAllGroups = temp.toString();
            }
            if (this.isRoleStoreDefined()) {
                temp = new StringBuilder("SELECT ");
                temp.append(this.roleNameCol);
                if (this.roleAndGroupDescriptionCol != null) {
                    temp.append(',').append(this.roleAndGroupDescriptionCol);
                }
                temp.append(" FROM ");
                temp.append(this.roleTable);
                temp.append(" WHERE ");
                temp.append(this.roleNameCol);
                temp.append(" = ?");
                this.preparedRole = temp.toString();
                temp = new StringBuilder("SELECT ");
                temp.append(this.roleNameCol);
                temp.append(" FROM ");
                temp.append(this.roleTable);
                this.preparedAllRoles = temp.toString();
            } else if (this.userRoleTable != null && this.roleNameCol != null) {
                temp = new StringBuilder("SELECT ");
                temp.append(this.roleNameCol);
                temp.append(" FROM ");
                temp.append(this.userRoleTable);
                temp.append(" WHERE ");
                temp.append(this.roleNameCol);
                temp.append(" = ?");
                this.preparedRole = temp.toString();
            }
        }
        finally {
            this.dbWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroup(Group group) {
        this.dbReadLock.lock();
        try {
            this.groupsWriteLock.lock();
            try {
                String name = group.getName();
                this.createdGroups.remove(name);
                this.modifiedGroups.remove(name);
                this.removedGroups.put(name, group);
            }
            finally {
                this.groupsWriteLock.unlock();
            }
        }
        finally {
            this.dbReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRole(Role role) {
        this.dbReadLock.lock();
        try {
            this.rolesWriteLock.lock();
            try {
                String name = role.getName();
                this.createdRoles.remove(name);
                this.modifiedRoles.remove(name);
                this.removedRoles.put(name, role);
            }
            finally {
                this.rolesWriteLock.unlock();
            }
        }
        finally {
            this.dbReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUser(User user) {
        this.dbReadLock.lock();
        try {
            this.usersWriteLock.lock();
            try {
                String name = user.getName();
                this.createdUsers.remove(name);
                this.modifiedUsers.remove(name);
                this.removedUsers.put(name, user);
            }
            finally {
                this.usersWriteLock.unlock();
            }
        }
        finally {
            this.dbReadLock.unlock();
        }
    }

    @Override
    public void save() throws Exception {
        if (this.readonly) {
            return;
        }
        Connection dbConnection = this.openConnection();
        if (dbConnection == null) {
            return;
        }
        this.dbWriteLock.lock();
        try {
            try {
                this.saveInternal(dbConnection);
            }
            finally {
                this.closeConnection(dbConnection);
            }
        }
        finally {
            this.dbWriteLock.unlock();
        }
    }

    protected void saveInternal(Connection dbConnection) {
        Object group;
        Iterator<Group> groups;
        Throwable throwable;
        PreparedStatement stmt;
        Role role;
        Iterator<Role> roles;
        Throwable throwable2;
        PreparedStatement stmt2;
        Object e4;
        PreparedStatement stmt3;
        StringBuilder temp = null;
        StringBuilder tempRelation = null;
        StringBuilder tempRelationDelete = null;
        if (this.isRoleStoreDefined()) {
            if (!this.removedRoles.isEmpty()) {
                temp = new StringBuilder("DELETE FROM ");
                temp.append(this.roleTable);
                temp.append(" WHERE ").append(this.roleNameCol);
                temp.append(" = ?");
                if (this.groupRoleTable != null) {
                    tempRelationDelete = new StringBuilder("DELETE FROM ");
                    tempRelationDelete.append(this.groupRoleTable);
                    tempRelationDelete.append(" WHERE ");
                    tempRelationDelete.append(this.roleNameCol);
                    tempRelationDelete.append(" = ?");
                }
                Iterator<Role> tempRelationDelete2 = new StringBuilder("DELETE FROM ");
                ((StringBuilder)((Object)tempRelationDelete2)).append(this.userRoleTable);
                ((StringBuilder)((Object)tempRelationDelete2)).append(" WHERE ");
                ((StringBuilder)((Object)tempRelationDelete2)).append(this.roleNameCol);
                ((StringBuilder)((Object)tempRelationDelete2)).append(" = ?");
                for (Role role2 : this.removedRoles.values()) {
                    Object object;
                    PreparedStatement stmt4;
                    if (tempRelationDelete != null) {
                        try {
                            stmt4 = dbConnection.prepareStatement(tempRelationDelete.toString());
                            object = null;
                            try {
                                stmt4.setString(1, role2.getRolename());
                                stmt4.executeUpdate();
                            }
                            catch (Throwable throwable3) {
                                object = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (stmt4 != null) {
                                    if (object != null) {
                                        try {
                                            stmt4.close();
                                        }
                                        catch (Throwable throwable4) {
                                            ((Throwable)object).addSuppressed(throwable4);
                                        }
                                    } else {
                                        stmt4.close();
                                    }
                                }
                            }
                        }
                        catch (SQLException e2) {
                            log.error(sm.getString("dataSourceUserDatabase.exception"), e2);
                        }
                    }
                    try {
                        stmt4 = dbConnection.prepareStatement(((StringBuilder)((Object)tempRelationDelete2)).toString());
                        object = null;
                        try {
                            stmt4.setString(1, role2.getRolename());
                            stmt4.executeUpdate();
                        }
                        catch (Throwable throwable5) {
                            object = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (stmt4 != null) {
                                if (object != null) {
                                    try {
                                        stmt4.close();
                                    }
                                    catch (Throwable throwable6) {
                                        ((Throwable)object).addSuppressed(throwable6);
                                    }
                                } else {
                                    stmt4.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e3) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e3);
                    }
                    try {
                        stmt4 = dbConnection.prepareStatement(temp.toString());
                        object = null;
                        try {
                            stmt4.setString(1, role2.getRolename());
                            stmt4.executeUpdate();
                        }
                        catch (Throwable throwable7) {
                            object = throwable7;
                            throw throwable7;
                        }
                        finally {
                            if (stmt4 == null) continue;
                            if (object != null) {
                                try {
                                    stmt4.close();
                                }
                                catch (Throwable throwable8) {
                                    ((Throwable)object).addSuppressed(throwable8);
                                }
                                continue;
                            }
                            stmt4.close();
                        }
                    }
                    catch (SQLException e4) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e4);
                    }
                }
                this.removedRoles.clear();
            }
            if (!this.createdRoles.isEmpty()) {
                temp = new StringBuilder("INSERT INTO ");
                temp.append(this.roleTable);
                temp.append('(').append(this.roleNameCol);
                if (this.roleAndGroupDescriptionCol != null) {
                    temp.append(',').append(this.roleAndGroupDescriptionCol);
                }
                temp.append(") VALUES (?");
                if (this.roleAndGroupDescriptionCol != null) {
                    temp.append(", ?");
                }
                temp.append(')');
                for (Role role3 : this.createdRoles.values()) {
                    try {
                        stmt3 = dbConnection.prepareStatement(temp.toString());
                        e4 = null;
                        try {
                            stmt3.setString(1, role3.getRolename());
                            if (this.roleAndGroupDescriptionCol != null) {
                                stmt3.setString(2, role3.getDescription());
                            }
                            stmt3.executeUpdate();
                        }
                        catch (Throwable throwable9) {
                            e4 = throwable9;
                            throw throwable9;
                        }
                        finally {
                            if (stmt3 == null) continue;
                            if (e4 != null) {
                                try {
                                    stmt3.close();
                                }
                                catch (Throwable throwable10) {
                                    ((Throwable)e4).addSuppressed(throwable10);
                                }
                                continue;
                            }
                            stmt3.close();
                        }
                    }
                    catch (SQLException e5) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e5);
                    }
                }
                this.createdRoles.clear();
            }
            if (!this.modifiedRoles.isEmpty() && this.roleAndGroupDescriptionCol != null) {
                temp = new StringBuilder("UPDATE ");
                temp.append(this.roleTable);
                temp.append(" SET ").append(this.roleAndGroupDescriptionCol);
                temp.append(" = ? WHERE ").append(this.roleNameCol);
                temp.append(" = ?");
                for (Role role3 : this.modifiedRoles.values()) {
                    try {
                        stmt3 = dbConnection.prepareStatement(temp.toString());
                        e4 = null;
                        try {
                            stmt3.setString(1, role3.getDescription());
                            stmt3.setString(2, role3.getRolename());
                            stmt3.executeUpdate();
                        }
                        catch (Throwable throwable11) {
                            e4 = throwable11;
                            throw throwable11;
                        }
                        finally {
                            if (stmt3 == null) continue;
                            if (e4 != null) {
                                try {
                                    stmt3.close();
                                }
                                catch (Throwable throwable12) {
                                    ((Throwable)e4).addSuppressed(throwable12);
                                }
                                continue;
                            }
                            stmt3.close();
                        }
                    }
                    catch (SQLException e6) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e6);
                    }
                }
                this.modifiedRoles.clear();
            }
        } else if (this.userRoleTable != null && this.roleNameCol != null) {
            tempRelationDelete = new StringBuilder("DELETE FROM ");
            tempRelationDelete.append(this.userRoleTable);
            tempRelationDelete.append(" WHERE ");
            tempRelationDelete.append(this.roleNameCol);
            tempRelationDelete.append(" = ?");
            for (Role role3 : this.removedRoles.values()) {
                try {
                    stmt3 = dbConnection.prepareStatement(tempRelationDelete.toString());
                    e4 = null;
                    try {
                        stmt3.setString(1, role3.getRolename());
                        stmt3.executeUpdate();
                    }
                    catch (Throwable throwable13) {
                        e4 = throwable13;
                        throw throwable13;
                    }
                    finally {
                        if (stmt3 == null) continue;
                        if (e4 != null) {
                            try {
                                stmt3.close();
                            }
                            catch (Throwable throwable14) {
                                ((Throwable)e4).addSuppressed(throwable14);
                            }
                            continue;
                        }
                        stmt3.close();
                    }
                }
                catch (SQLException e7) {
                    log.error(sm.getString("dataSourceUserDatabase.exception"), e7);
                }
            }
            this.removedRoles.clear();
        }
        if (this.isGroupStoreDefined()) {
            Object role4;
            Iterator<Role> roles2;
            PreparedStatement stmt5;
            tempRelation = new StringBuilder("INSERT INTO ");
            tempRelation.append(this.groupRoleTable);
            tempRelation.append('(').append(this.groupNameCol).append(", ");
            tempRelation.append(this.roleNameCol);
            tempRelation.append(") VALUES (?, ?)");
            String groupRoleRelation = tempRelation.toString();
            tempRelationDelete = new StringBuilder("DELETE FROM ");
            tempRelationDelete.append(this.groupRoleTable);
            tempRelationDelete.append(" WHERE ");
            tempRelationDelete.append(this.groupNameCol);
            tempRelationDelete.append(" = ?");
            String groupRoleRelationDelete = tempRelationDelete.toString();
            if (!this.removedGroups.isEmpty()) {
                temp = new StringBuilder("DELETE FROM ");
                temp.append(this.groupTable);
                temp.append(" WHERE ").append(this.groupNameCol);
                temp.append(" = ?");
                Iterator<Group> tempRelationDelete2 = new StringBuilder("DELETE FROM ");
                ((StringBuilder)((Object)tempRelationDelete2)).append(this.userGroupTable);
                ((StringBuilder)((Object)tempRelationDelete2)).append(" WHERE ");
                ((StringBuilder)((Object)tempRelationDelete2)).append(this.groupNameCol);
                ((StringBuilder)((Object)tempRelationDelete2)).append(" = ?");
                for (Group group2 : this.removedGroups.values()) {
                    Throwable throwable15;
                    PreparedStatement stmt6;
                    try {
                        stmt6 = dbConnection.prepareStatement(groupRoleRelationDelete);
                        throwable15 = null;
                        try {
                            stmt6.setString(1, group2.getGroupname());
                            stmt6.executeUpdate();
                        }
                        catch (Throwable throwable16) {
                            throwable15 = throwable16;
                            throw throwable16;
                        }
                        finally {
                            if (stmt6 != null) {
                                if (throwable15 != null) {
                                    try {
                                        stmt6.close();
                                    }
                                    catch (Throwable throwable17) {
                                        throwable15.addSuppressed(throwable17);
                                    }
                                } else {
                                    stmt6.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e8) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e8);
                    }
                    try {
                        stmt6 = dbConnection.prepareStatement(((StringBuilder)((Object)tempRelationDelete2)).toString());
                        throwable15 = null;
                        try {
                            stmt6.setString(1, group2.getGroupname());
                            stmt6.executeUpdate();
                        }
                        catch (Throwable throwable18) {
                            throwable15 = throwable18;
                            throw throwable18;
                        }
                        finally {
                            if (stmt6 != null) {
                                if (throwable15 != null) {
                                    try {
                                        stmt6.close();
                                    }
                                    catch (Throwable throwable19) {
                                        throwable15.addSuppressed(throwable19);
                                    }
                                } else {
                                    stmt6.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e9) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e9);
                    }
                    try {
                        stmt6 = dbConnection.prepareStatement(temp.toString());
                        throwable15 = null;
                        try {
                            stmt6.setString(1, group2.getGroupname());
                            stmt6.executeUpdate();
                        }
                        catch (Throwable throwable20) {
                            throwable15 = throwable20;
                            throw throwable20;
                        }
                        finally {
                            if (stmt6 == null) continue;
                            if (throwable15 != null) {
                                try {
                                    stmt6.close();
                                }
                                catch (Throwable throwable21) {
                                    throwable15.addSuppressed(throwable21);
                                }
                                continue;
                            }
                            stmt6.close();
                        }
                    }
                    catch (SQLException e10) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e10);
                    }
                }
                this.removedGroups.clear();
            }
            if (!this.createdGroups.isEmpty()) {
                temp = new StringBuilder("INSERT INTO ");
                temp.append(this.groupTable);
                temp.append('(').append(this.groupNameCol);
                if (this.roleAndGroupDescriptionCol != null) {
                    temp.append(',').append(this.roleAndGroupDescriptionCol);
                }
                temp.append(") VALUES (?");
                if (this.roleAndGroupDescriptionCol != null) {
                    temp.append(", ?");
                }
                temp.append(')');
                for (Group group3 : this.createdGroups.values()) {
                    try {
                        stmt5 = dbConnection.prepareStatement(temp.toString());
                        Throwable e10 = null;
                        try {
                            stmt5.setString(1, group3.getGroupname());
                            if (this.roleAndGroupDescriptionCol != null) {
                                stmt5.setString(2, group3.getDescription());
                            }
                            stmt5.executeUpdate();
                        }
                        catch (Throwable throwable22) {
                            e10 = throwable22;
                            throw throwable22;
                        }
                        finally {
                            if (stmt5 != null) {
                                if (e10 != null) {
                                    try {
                                        stmt5.close();
                                    }
                                    catch (Throwable throwable23) {
                                        e10.addSuppressed(throwable23);
                                    }
                                } else {
                                    stmt5.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e11) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e11);
                    }
                    roles2 = group3.getRoles();
                    while (roles2.hasNext()) {
                        role4 = roles2.next();
                        try {
                            stmt2 = dbConnection.prepareStatement(groupRoleRelation);
                            throwable2 = null;
                            try {
                                stmt2.setString(1, group3.getGroupname());
                                stmt2.setString(2, role4.getRolename());
                                stmt2.executeUpdate();
                            }
                            catch (Throwable throwable24) {
                                throwable2 = throwable24;
                                throw throwable24;
                            }
                            finally {
                                if (stmt2 == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        stmt2.close();
                                    }
                                    catch (Throwable throwable25) {
                                        throwable2.addSuppressed(throwable25);
                                    }
                                    continue;
                                }
                                stmt2.close();
                            }
                        }
                        catch (SQLException e12) {
                            log.error(sm.getString("dataSourceUserDatabase.exception"), e12);
                        }
                    }
                }
                this.createdGroups.clear();
            }
            if (!this.modifiedGroups.isEmpty()) {
                if (this.roleAndGroupDescriptionCol != null) {
                    temp = new StringBuilder("UPDATE ");
                    temp.append(this.groupTable);
                    temp.append(" SET ").append(this.roleAndGroupDescriptionCol);
                    temp.append(" = ? WHERE ").append(this.groupNameCol);
                    temp.append(" = ?");
                }
                for (Group group3 : this.modifiedGroups.values()) {
                    if (temp != null) {
                        try {
                            stmt5 = dbConnection.prepareStatement(temp.toString());
                            role4 = null;
                            try {
                                stmt5.setString(1, group3.getDescription());
                                stmt5.setString(2, group3.getGroupname());
                                stmt5.executeUpdate();
                            }
                            catch (Throwable e12) {
                                role4 = e12;
                                throw e12;
                            }
                            finally {
                                if (stmt5 != null) {
                                    if (role4 != null) {
                                        try {
                                            stmt5.close();
                                        }
                                        catch (Throwable e12) {
                                            ((Throwable)role4).addSuppressed(e12);
                                        }
                                    } else {
                                        stmt5.close();
                                    }
                                }
                            }
                        }
                        catch (SQLException e13) {
                            log.error(sm.getString("dataSourceUserDatabase.exception"), e13);
                        }
                    }
                    try {
                        stmt5 = dbConnection.prepareStatement(groupRoleRelationDelete);
                        role4 = null;
                        try {
                            stmt5.setString(1, group3.getGroupname());
                            stmt5.executeUpdate();
                        }
                        catch (Throwable e12) {
                            role4 = e12;
                            throw e12;
                        }
                        finally {
                            if (stmt5 != null) {
                                if (role4 != null) {
                                    try {
                                        stmt5.close();
                                    }
                                    catch (Throwable e12) {
                                        ((Throwable)role4).addSuppressed(e12);
                                    }
                                } else {
                                    stmt5.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e14) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e14);
                    }
                    roles2 = group3.getRoles();
                    while (roles2.hasNext()) {
                        role4 = roles2.next();
                        try {
                            stmt2 = dbConnection.prepareStatement(groupRoleRelation);
                            throwable2 = null;
                            try {
                                stmt2.setString(1, group3.getGroupname());
                                stmt2.setString(2, role4.getRolename());
                                stmt2.executeUpdate();
                            }
                            catch (Throwable throwable26) {
                                throwable2 = throwable26;
                                throw throwable26;
                            }
                            finally {
                                if (stmt2 == null) continue;
                                if (throwable2 != null) {
                                    try {
                                        stmt2.close();
                                    }
                                    catch (Throwable throwable27) {
                                        throwable2.addSuppressed(throwable27);
                                    }
                                    continue;
                                }
                                stmt2.close();
                            }
                        }
                        catch (SQLException e15) {
                            log.error(sm.getString("dataSourceUserDatabase.exception"), e15);
                        }
                    }
                }
                this.modifiedGroups.clear();
            }
        }
        String userRoleRelation = null;
        String userRoleRelationDelete = null;
        if (this.userRoleTable != null && this.roleNameCol != null) {
            tempRelation = new StringBuilder("INSERT INTO ");
            tempRelation.append(this.userRoleTable);
            tempRelation.append('(').append(this.userNameCol).append(", ");
            tempRelation.append(this.roleNameCol);
            tempRelation.append(") VALUES (?, ?)");
            userRoleRelation = tempRelation.toString();
            tempRelationDelete = new StringBuilder("DELETE FROM ");
            tempRelationDelete.append(this.userRoleTable);
            tempRelationDelete.append(" WHERE ");
            tempRelationDelete.append(this.userNameCol);
            tempRelationDelete.append(" = ?");
            userRoleRelationDelete = tempRelationDelete.toString();
        }
        String userGroupRelation = null;
        String userGroupRelationDelete = null;
        if (this.isGroupStoreDefined()) {
            tempRelation = new StringBuilder("INSERT INTO ");
            tempRelation.append(this.userGroupTable);
            tempRelation.append('(').append(this.userNameCol).append(", ");
            tempRelation.append(this.groupNameCol);
            tempRelation.append(") VALUES (?, ?)");
            userGroupRelation = tempRelation.toString();
            tempRelationDelete = new StringBuilder("DELETE FROM ");
            tempRelationDelete.append(this.userGroupTable);
            tempRelationDelete.append(" WHERE ");
            tempRelationDelete.append(this.userNameCol);
            tempRelationDelete.append(" = ?");
            userGroupRelationDelete = tempRelationDelete.toString();
        }
        if (!this.removedUsers.isEmpty()) {
            temp = new StringBuilder("DELETE FROM ");
            temp.append(this.userTable);
            temp.append(" WHERE ").append(this.userNameCol);
            temp.append(" = ?");
            for (User user : this.removedUsers.values()) {
                if (userRoleRelationDelete != null) {
                    try {
                        stmt2 = dbConnection.prepareStatement(userRoleRelationDelete);
                        throwable2 = null;
                        try {
                            stmt2.setString(1, user.getUsername());
                            stmt2.executeUpdate();
                        }
                        catch (Throwable throwable28) {
                            throwable2 = throwable28;
                            throw throwable28;
                        }
                        finally {
                            if (stmt2 != null) {
                                if (throwable2 != null) {
                                    try {
                                        stmt2.close();
                                    }
                                    catch (Throwable throwable29) {
                                        throwable2.addSuppressed(throwable29);
                                    }
                                } else {
                                    stmt2.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e16) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e16);
                    }
                }
                if (userGroupRelationDelete != null) {
                    try {
                        stmt2 = dbConnection.prepareStatement(userGroupRelationDelete);
                        throwable2 = null;
                        try {
                            stmt2.setString(1, user.getUsername());
                            stmt2.executeUpdate();
                        }
                        catch (Throwable throwable30) {
                            throwable2 = throwable30;
                            throw throwable30;
                        }
                        finally {
                            if (stmt2 != null) {
                                if (throwable2 != null) {
                                    try {
                                        stmt2.close();
                                    }
                                    catch (Throwable throwable31) {
                                        throwable2.addSuppressed(throwable31);
                                    }
                                } else {
                                    stmt2.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e17) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e17);
                    }
                }
                try {
                    stmt2 = dbConnection.prepareStatement(temp.toString());
                    throwable2 = null;
                    try {
                        stmt2.setString(1, user.getUsername());
                        stmt2.executeUpdate();
                    }
                    catch (Throwable throwable32) {
                        throwable2 = throwable32;
                        throw throwable32;
                    }
                    finally {
                        if (stmt2 == null) continue;
                        if (throwable2 != null) {
                            try {
                                stmt2.close();
                            }
                            catch (Throwable throwable33) {
                                throwable2.addSuppressed(throwable33);
                            }
                            continue;
                        }
                        stmt2.close();
                    }
                }
                catch (SQLException e18) {
                    log.error(sm.getString("dataSourceUserDatabase.exception"), e18);
                }
            }
            this.removedUsers.clear();
        }
        if (!this.createdUsers.isEmpty()) {
            temp = new StringBuilder("INSERT INTO ");
            temp.append(this.userTable);
            temp.append('(').append(this.userNameCol);
            temp.append(", ").append(this.userCredCol);
            if (this.userFullNameCol != null) {
                temp.append(',').append(this.userFullNameCol);
            }
            temp.append(") VALUES (?, ?");
            if (this.userFullNameCol != null) {
                temp.append(", ?");
            }
            temp.append(')');
            for (User user : this.createdUsers.values()) {
                try {
                    stmt2 = dbConnection.prepareStatement(temp.toString());
                    throwable2 = null;
                    try {
                        stmt2.setString(1, user.getUsername());
                        stmt2.setString(2, user.getPassword());
                        if (this.userFullNameCol != null) {
                            stmt2.setString(3, user.getFullName());
                        }
                        stmt2.executeUpdate();
                    }
                    catch (Throwable throwable34) {
                        throwable2 = throwable34;
                        throw throwable34;
                    }
                    finally {
                        if (stmt2 != null) {
                            if (throwable2 != null) {
                                try {
                                    stmt2.close();
                                }
                                catch (Throwable throwable35) {
                                    throwable2.addSuppressed(throwable35);
                                }
                            } else {
                                stmt2.close();
                            }
                        }
                    }
                }
                catch (SQLException e19) {
                    log.error(sm.getString("dataSourceUserDatabase.exception"), e19);
                }
                if (userRoleRelation != null) {
                    roles = user.getRoles();
                    while (roles.hasNext()) {
                        role = roles.next();
                        try {
                            stmt = dbConnection.prepareStatement(userRoleRelation);
                            throwable = null;
                            try {
                                stmt.setString(1, user.getUsername());
                                stmt.setString(2, role.getRolename());
                                stmt.executeUpdate();
                            }
                            catch (Throwable throwable36) {
                                throwable = throwable36;
                                throw throwable36;
                            }
                            finally {
                                if (stmt == null) continue;
                                if (throwable != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable throwable37) {
                                        throwable.addSuppressed(throwable37);
                                    }
                                    continue;
                                }
                                stmt.close();
                            }
                        }
                        catch (SQLException e20) {
                            log.error(sm.getString("dataSourceUserDatabase.exception"), e20);
                        }
                    }
                }
                if (userGroupRelation == null) continue;
                groups = user.getGroups();
                while (groups.hasNext()) {
                    group = groups.next();
                    try {
                        stmt = dbConnection.prepareStatement(userGroupRelation);
                        throwable = null;
                        try {
                            stmt.setString(1, user.getUsername());
                            stmt.setString(2, group.getGroupname());
                            stmt.executeUpdate();
                        }
                        catch (Throwable throwable38) {
                            throwable = throwable38;
                            throw throwable38;
                        }
                        finally {
                            if (stmt == null) continue;
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable39) {
                                    throwable.addSuppressed(throwable39);
                                }
                                continue;
                            }
                            stmt.close();
                        }
                    }
                    catch (SQLException e21) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e21);
                    }
                }
            }
            this.createdUsers.clear();
        }
        if (!this.modifiedUsers.isEmpty()) {
            temp = new StringBuilder("UPDATE ");
            temp.append(this.userTable);
            temp.append(" SET ").append(this.userCredCol);
            temp.append(" = ?");
            if (this.userFullNameCol != null) {
                temp.append(", ").append(this.userFullNameCol).append(" = ?");
            }
            temp.append(" WHERE ").append(this.userNameCol);
            temp.append(" = ?");
            for (User user : this.modifiedUsers.values()) {
                try {
                    stmt2 = dbConnection.prepareStatement(temp.toString());
                    group = null;
                    try {
                        stmt2.setString(1, user.getPassword());
                        if (this.userFullNameCol != null) {
                            stmt2.setString(2, user.getFullName());
                            stmt2.setString(3, user.getUsername());
                        } else {
                            stmt2.setString(2, user.getUsername());
                        }
                        stmt2.executeUpdate();
                    }
                    catch (Throwable e21) {
                        group = e21;
                        throw e21;
                    }
                    finally {
                        if (stmt2 != null) {
                            if (group != null) {
                                try {
                                    stmt2.close();
                                }
                                catch (Throwable e21) {
                                    ((Throwable)group).addSuppressed(e21);
                                }
                            } else {
                                stmt2.close();
                            }
                        }
                    }
                }
                catch (SQLException e22) {
                    log.error(sm.getString("dataSourceUserDatabase.exception"), e22);
                }
                if (userRoleRelationDelete != null) {
                    try {
                        stmt2 = dbConnection.prepareStatement(userRoleRelationDelete);
                        group = null;
                        try {
                            stmt2.setString(1, user.getUsername());
                            stmt2.executeUpdate();
                        }
                        catch (Throwable e21) {
                            group = e21;
                            throw e21;
                        }
                        finally {
                            if (stmt2 != null) {
                                if (group != null) {
                                    try {
                                        stmt2.close();
                                    }
                                    catch (Throwable e21) {
                                        ((Throwable)group).addSuppressed(e21);
                                    }
                                } else {
                                    stmt2.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e23) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e23);
                    }
                }
                if (userGroupRelationDelete != null) {
                    try {
                        stmt2 = dbConnection.prepareStatement(userGroupRelationDelete);
                        group = null;
                        try {
                            stmt2.setString(1, user.getUsername());
                            stmt2.executeUpdate();
                        }
                        catch (Throwable e21) {
                            group = e21;
                            throw e21;
                        }
                        finally {
                            if (stmt2 != null) {
                                if (group != null) {
                                    try {
                                        stmt2.close();
                                    }
                                    catch (Throwable e21) {
                                        ((Throwable)group).addSuppressed(e21);
                                    }
                                } else {
                                    stmt2.close();
                                }
                            }
                        }
                    }
                    catch (SQLException e24) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e24);
                    }
                }
                if (userRoleRelation != null) {
                    roles = user.getRoles();
                    while (roles.hasNext()) {
                        role = roles.next();
                        try {
                            stmt = dbConnection.prepareStatement(userRoleRelation);
                            throwable = null;
                            try {
                                stmt.setString(1, user.getUsername());
                                stmt.setString(2, role.getRolename());
                                stmt.executeUpdate();
                            }
                            catch (Throwable throwable40) {
                                throwable = throwable40;
                                throw throwable40;
                            }
                            finally {
                                if (stmt == null) continue;
                                if (throwable != null) {
                                    try {
                                        stmt.close();
                                    }
                                    catch (Throwable throwable41) {
                                        throwable.addSuppressed(throwable41);
                                    }
                                    continue;
                                }
                                stmt.close();
                            }
                        }
                        catch (SQLException e25) {
                            log.error(sm.getString("dataSourceUserDatabase.exception"), e25);
                        }
                    }
                }
                if (userGroupRelation == null) continue;
                groups = user.getGroups();
                while (groups.hasNext()) {
                    group = groups.next();
                    try {
                        stmt = dbConnection.prepareStatement(userGroupRelation);
                        throwable = null;
                        try {
                            stmt.setString(1, user.getUsername());
                            stmt.setString(2, group.getGroupname());
                            stmt.executeUpdate();
                        }
                        catch (Throwable throwable42) {
                            throwable = throwable42;
                            throw throwable42;
                        }
                        finally {
                            if (stmt == null) continue;
                            if (throwable != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable43) {
                                    throwable.addSuppressed(throwable43);
                                }
                                continue;
                            }
                            stmt.close();
                        }
                    }
                    catch (SQLException e26) {
                        log.error(sm.getString("dataSourceUserDatabase.exception"), e26);
                    }
                }
            }
            this.modifiedGroups.clear();
        }
    }

    @Override
    public boolean isAvailable() {
        return this.connectionSuccess;
    }

    protected boolean isGroupStoreDefined() {
        return this.groupTable != null && this.userGroupTable != null && this.groupNameCol != null && this.groupRoleTable != null && this.isRoleStoreDefined();
    }

    protected boolean isRoleStoreDefined() {
        return this.roleTable != null && this.userRoleTable != null && this.roleNameCol != null;
    }

    protected Connection openConnection() {
        if (this.dataSource == null) {
            return null;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            this.connectionSuccess = true;
            return connection;
        }
        catch (Exception e) {
            this.connectionSuccess = false;
            log.error(sm.getString("dataSourceUserDatabase.exception"), e);
            return null;
        }
    }

    protected void closeConnection(Connection dbConnection) {
        if (dbConnection == null) {
            return;
        }
        try {
            if (!dbConnection.getAutoCommit()) {
                dbConnection.commit();
            }
        }
        catch (SQLException e) {
            log.error(sm.getString("dataSourceUserDatabase.exception"), e);
        }
        try {
            dbConnection.close();
        }
        catch (SQLException e) {
            log.error(sm.getString("dataSourceUserDatabase.exception"), e);
        }
    }
}

