/*
 * Decompiled with CFR 0.152.
 */
package com.tongtech.tfw.dv2.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.CollectionHelper;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import com.tongtech.tfw.backend.core.helper.json.JacksonHelper;
import com.tongtech.tfw.dv2.model.domain.BladeVisualMap;
import com.tongtech.tfw.dv2.model.dto.BladeVisualMapDelParam;
import com.tongtech.tfw.dv2.model.dto.BladeVisualMapParam;
import com.tongtech.tfw.dv2.service.BladeVisualMapService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/visual/map"})
@Api(value="BladeVisualMap", tags={"\u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e"})
public class BladeVisualMapController
extends SuperController {
    private static final Logger log = LoggerFactory.getLogger(BladeVisualMapController.class);
    @Autowired
    private BladeVisualMapService bladeVisualMapService;

    @ApiOperation(value="\u65b0\u589e \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e", notes="Add BladeVisualMap")
    @PostMapping(value={"/save"})
    public BaseResponse<BladeVisualMap> addEntity(@RequestBody BladeVisualMap addRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)addRequest)) {
            String id = IdHelper.getId32bit();
            BladeVisualMap data = (BladeVisualMap)BeanHelper.beanToBean((Object)addRequest, BladeVisualMap.class);
            data.setId(id);
            boolean result = this.bladeVisualMapService.save(data);
            if (result) {
                BladeVisualMap newEntity = new BladeVisualMap();
                newEntity.setId(id);
                baseResponse.setData((Object)newEntity);
            }
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e ", notes="Get BladeVisualMap By Id")
    @GetMapping(value={"/get"})
    public BaseResponse<BladeVisualMap> getById(String id) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotEmpty((CharSequence)id)) {
            BladeVisualMap data = (BladeVisualMap)this.bladeVisualMapService.getById((Serializable)((Object)id));
            baseResponse.setData((Object)data);
        }
        return baseResponse;
    }

    @GetMapping(value={"/data"})
    @ApiOperationSupport(order=2)
    @ApiOperation(value="\u6570\u636e\u8be6\u60c5", notes="\u4f20\u5165id")
    public BaseResponse<Map<String, Object>> data(String id) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotBlank((CharSequence)id)) {
            BladeVisualMap data = (BladeVisualMap)this.bladeVisualMapService.getById((Serializable)((Object)id));
            baseResponse.setData(JacksonHelper.readValue((String)data.getData(), Map.class));
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e ", notes="\u4f20\u5165visualMap")
    @GetMapping(value={"/detail"})
    public BaseResponse<BladeVisualMap> detail(BladeVisualMapParam param) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)param)) {
            QueryWrapper<BladeVisualMap> queryWrapper = this.createQuery(param);
            BladeVisualMap data = (BladeVisualMap)this.bladeVisualMapService.getOne((Wrapper)queryWrapper);
            baseResponse.setData((Object)data);
        }
        return baseResponse;
    }

    @ApiOperation(value="\u4fee\u6539 \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e ", notes="Update BladeVisualMap By Id")
    @PutMapping(value={"/update"})
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody BladeVisualMap updateRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)updateRequest) && StringHelper.isNotEmpty((CharSequence)updateRequest.getId())) {
            BladeVisualMap data = (BladeVisualMap)BeanHelper.beanToBean((Object)updateRequest, BladeVisualMap.class);
            boolean result = this.bladeVisualMapService.updateById(data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u5220\u9664 \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e ", notes="delete BladeVisualMap By Id")
    @PutMapping(value={"/delete"})
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody BladeVisualMapDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && StringHelper.isNotEmpty((CharSequence)deleteRequest.getId())) {
            BladeVisualMap data = new BladeVisualMap();
            data.setId(deleteRequest.getId());
            data.setStatus("1");
            boolean result = this.bladeVisualMapService.updateById(data);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e", notes="delete BladeVisualMap by batch Id")
    @PutMapping(value={"/batch_delete"})
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(@RequestBody BladeVisualMapDelParam deleteRequest) {
        BaseResponse baseResponse = new BaseResponse();
        if (ObjectHelper.isNotEmpty((Object)deleteRequest) && !deleteRequest.getIds().isEmpty()) {
            ArrayList<BladeVisualMap> bladeVisualMapList = new ArrayList<BladeVisualMap>();
            for (String id : deleteRequest.getIds()) {
                BladeVisualMap data = new BladeVisualMap();
                data.setId(id);
                data.setStatus("1");
                bladeVisualMapList.add(data);
            }
            boolean result = this.bladeVisualMapService.updateBatchById(bladeVisualMapList);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @PostMapping(value={"/remove"})
    @ApiOperation(value="\u5220\u9664", notes="delete BladeVisual by batch Id")
    public BaseResponse<BizGeneralResponse> remove(@RequestParam String ids) {
        BaseResponse baseResponse = new BaseResponse();
        if (StringHelper.isNotBlank((CharSequence)ids)) {
            List idList = CollectionHelper.arrayToList((Object)StringHelper.split((String)ids, (String)","));
            ArrayList<BladeVisualMap> deleteList = new ArrayList<BladeVisualMap>(idList.size());
            for (String id : idList) {
                BladeVisualMap bladeVisual = new BladeVisualMap();
                bladeVisual.setId(id);
                bladeVisual.setStatus("1");
                deleteList.add(bladeVisual);
            }
            boolean result = this.bladeVisualMapService.updateBatchById(deleteList);
            baseResponse.setData((Object)BizGeneralResponse.builder().result(TypeHelper.castToString((Object)result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e \u5206\u9875\u5217\u8868", notes="List BladeVisualMap with page")
    @GetMapping(value={"/list"})
    public BaseResponse<BaseResponseList<BladeVisualMap>> listEntity(BladeVisualMapParam param) {
        BaseResponse baseResponse = new BaseResponse();
        Long page = StringHelper.isEmpty((CharSequence)param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit = StringHelper.isEmpty((CharSequence)param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page resultPage = new Page(page.longValue(), limit.longValue());
        QueryWrapper<BladeVisualMap> queryWrapper = this.createQuery(param);
        Page resultList = (Page)this.bladeVisualMapService.page((IPage)resultPage, (Wrapper)queryWrapper.select(new String[]{"id", "name", "status"}));
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value="\u83b7\u53d6 \u53ef\u89c6\u5316\u5730\u56fe\u914d\u7f6e \u5217\u8868", notes="List BladeVisualMap all")
    @GetMapping(value={"/datas"})
    public BaseResponse<BaseResponseList<BladeVisualMap>> listAllEntity(BladeVisualMapParam param) {
        BaseResponse baseResponse = new BaseResponse();
        QueryWrapper<BladeVisualMap> queryWrapper = this.createQuery(param);
        List resultList = this.bladeVisualMapService.list((Wrapper)queryWrapper);
        BaseResponseList baseResponseList = new BaseResponseList();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal((long)resultList.size());
        baseResponse.setData((Object)baseResponseList);
        return baseResponse;
    }

    private QueryWrapper<BladeVisualMap> createQuery(BladeVisualMapParam queryParam) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getId())) {
            queryWrapper.like((Object)"id", (Object)queryParam.getId());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getName())) {
            queryWrapper.like((Object)"name", (Object)queryParam.getName());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getData())) {
            queryWrapper.eq((Object)"data", (Object)queryParam.getData());
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)queryParam.getStatus());
        } else {
            queryWrapper.ne((Object)"status", (Object)"1");
        }
        if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty((CharSequence)queryParam.getOrderType()) && "asc".equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc((Object)queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc((Object)queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc((Object)"id");
        }
        return queryWrapper;
    }
}

