package com.testor.ddd.safetyControl.application.service.riskMap.impl;

import cn.hutool.core.util.StrUtil;
import com.testor.biz.sys.dict.data.model.domain.SysDictData;
import com.testor.biz.sys.dict.data.service.SysDictDataService;
import com.testor.ddd.safetyControl.application.service.riskMap.RiskMapElementManageService;
import com.testor.ddd.safetyControl.application.service.spaceManage.SpaceManageService;
import com.testor.ddd.safetyControl.domain.riskMap.entity.TSafeRiskMapElementRepo;
import com.testor.ddd.safetyControl.domain.riskMap.service.RiskMapElementService;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskMap.TSafeRiskMapElementDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskMap.TSafeRiskMapElementDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.dto.space.TSafeSpaceDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskMap.TSafeRiskMapElementVO;
import com.testor.ddd.safetyControl.interfaces.model.vo.space.TSafeSpaceVO;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class RiskMapElementManageServiceImpl implements RiskMapElementManageService {

    @Resource
    private RiskMapElementService riskMapElementService;

    @Resource
    private TSafeRiskMapElementRepo tSafeRiskMapElementRepo;

    @Resource
    private SysDictDataService dictDataService;

    @Resource
    private SpaceManageService spaceManageService;

    @Transactional
    public BaseResponse editRiskMapElement(String riskBizId, List<TSafeRiskMapElementDTO> riskMapElementDtoList) throws RuntimeException {

       return riskMapElementService.editRiskMapElement(riskBizId, riskMapElementDtoList);
       
    }

    public BaseResponseList<TSafeRiskMapElementVO> listPage(TSafeRiskMapElementDTOParam param){

        BaseResponseList<TSafeRiskMapElementVO> list = tSafeRiskMapElementRepo.listPage(param);
        if(list.getTotal() < 1) {
            return list;
        }

        List<TSafeRiskMapElementVO> finalRiskMapElementVOList = list.getData().stream().map(vo -> {
            generateDictData(vo);
            return generateSpace(vo);

        }).collect(Collectors.toList());

        list.setData(finalRiskMapElementVOList);
        return list;
    }

    // 组装 实体中的 数据字典
    public TSafeRiskMapElementVO generateDictData(TSafeRiskMapElementVO riskMapElementVO) {
        if (StrUtil.isBlank(riskMapElementVO.getId())) {
            return null;
        }

        // 固有风险
        SysDictData inherentLevel = dictDataService.getById(riskMapElementVO.getInherentLevelId());
        if (inherentLevel != null) {
            riskMapElementVO.setInherentLevelName(inherentLevel.getDictValue());
            riskMapElementVO.setInherentLevelCode(inherentLevel.getDictKey());
        }
        //现实风险
        SysDictData realType = dictDataService.getById(riskMapElementVO.getRealLevelId());
        if (realType != null) {
            riskMapElementVO.setRealLevelName(realType.getDictValue());
            riskMapElementVO.setRealLevelCode(realType.getDictKey());
        }

        return riskMapElementVO;
    }

    // 组装 实体中的 空间
    public TSafeRiskMapElementVO generateSpace(TSafeRiskMapElementVO riskMapElementVO) {
        if (StrUtil.isBlank(riskMapElementVO.getId())) {
            return null;
        }

        int spaceLevel = 0;
        // 危险类型
        TSafeSpaceDTOParam param = new TSafeSpaceDTOParam();
        param.setId(riskMapElementVO.getSpaceId());

        param.setLevel(spaceLevel);
        List<TSafeSpaceVO> riskOwnerVOList = spaceManageService.listByPage(param).getData();
        if(riskOwnerVOList != null && riskOwnerVOList.size() > 0) {
            TSafeSpaceVO spaceVo = riskOwnerVOList.get(0);
            riskMapElementVO.setSpaceName(spaceVo.getName());
        }
        return riskMapElementVO;
    }

    public BaseResponse deleteByRiskBizId(String riskBizId) throws RuntimeException {
        BaseResponse baseResponse = new BaseResponse<>();
        boolean deleteResult = tSafeRiskMapElementRepo.deleteByRiskBizId(riskBizId);
        return baseResponse;
    }
}
