package com.testor.ddd.safetyControl.application.service.riskMap.impl;

import cn.hutool.core.util.StrUtil;
import com.testor.biz.sys.org.model.domain.SysOrg;
import com.testor.biz.sys.org.service.SysOrgService;
import com.testor.ddd.safetyControl.application.service.riskMap.RiskMapElementManageService;
import com.testor.ddd.safetyControl.application.service.riskMap.RiskMapManageService;
import com.testor.ddd.safetyControl.application.service.riskSourceManage.RiskSourceManageService;
import com.testor.ddd.safetyControl.domain.riskMap.entity.TSafeRiskMapRepo;
import com.testor.ddd.safetyControl.domain.riskMap.service.RiskMapService;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskMap.TSafeRiskMapElementDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskMap.TSafeRiskMapElementDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskMap.TSafeRiskMapDTO;
import com.testor.ddd.safetyControl.interfaces.model.dto.riskMap.TSafeRiskMapDTOParam;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskMap.TSafeRiskMapElementVO;
import com.testor.ddd.safetyControl.interfaces.model.vo.riskMap.TSafeRiskMapVO;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.constants.enumeration.BaseStatusEnum;
import com.tongtech.tfw.backend.common.context.ContextUtils;
import com.tongtech.tfw.backend.common.models.sys.UserInfo;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

@Service("riskMapManageService")
public class RiskMapManageServiceImpl implements RiskMapManageService {

    @Resource
    private SysOrgService orgService;

    @Resource
    private RiskMapService riskMapService;

    @Resource
    private TSafeRiskMapRepo tSafeRiskMapRepo;
    
    @Resource
    private RiskMapElementManageService riskMapElementManageService;

    @Resource
    private RiskSourceManageService riskSourceManageService;

    /**
     * 编辑空间
     *
     * @param riskMapDto
     * @return
     */
    @Transactional
    public BaseResponse<TSafeRiskMapDTO> editRiskMap(TSafeRiskMapDTO riskMapDto) throws RuntimeException {
        BaseResponse<TSafeRiskMapDTO> baseResponse = new BaseResponse<>();

        UserInfo curUser = ContextUtils.getLoginUser();
        System.out.println("************curUser:"+curUser.getOrgId());
        if (StrUtil.isBlank(curUser.getOrgId())) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("用户信息错误");
            return baseResponse;
        }
        String curUserOrgId = curUser.getOrgId();
        riskMapDto.setOrgId(curUserOrgId);

        // 处理区域公司 、 基层单位
        String orgStrs = orgAllPath(curUserOrgId);
        if(!StrUtil.isBlank(orgStrs)) {
            String[] orgArr = orgStrs.split(",");
            if(orgArr.length == 3) {
                riskMapDto.setRegionOrgId(orgArr[2]);
            }
            if(orgArr.length > 3) {
                riskMapDto.setRegionOrgId(orgArr[2]);
                riskMapDto.setBasicOrgId(orgArr[orgArr.length-1]);
            }
        }

        List<TSafeRiskMapElementDTO> riskMapElementDTOList = riskMapDto.getMapElementList();
        baseResponse = riskMapService.editRiskMap(curUser.getUserId(), curUserOrgId, riskMapDto);
        if (baseResponse.getCode() != 200) {
            baseResponse.setMsg("用户信息错误");
            return baseResponse;
        }

        riskMapElementManageService.editRiskMapElement(baseResponse.getData().getId(), riskMapElementDTOList);
        return baseResponse;
    }

    public BaseResponseList<TSafeRiskMapVO> listByPage(TSafeRiskMapDTOParam param) {

        if (StrUtil.isBlank(param.getOrgId())) {
            UserInfo curUser = ContextUtils.getLoginUser();
            String curUserOrgId = curUser.getOrgId();
            param.setOrgId(curUserOrgId);
        }

        BaseResponseList<TSafeRiskMapVO> responseList = riskMapService.listByPage(param);
        List<TSafeRiskMapVO> riskMapVOList = responseList.getData();
        if (riskMapVOList == null || riskMapVOList.size() == 0) {
            return responseList;
        }

        responseList.setData(riskMapVOList);
        return responseList;
    }

    public TSafeRiskMapDTO findById(String id) {
        return tSafeRiskMapRepo.findById(id);
    }

    public TSafeRiskMapVO findDetailById(String id) {
        TSafeRiskMapVO riskMapVO = tSafeRiskMapRepo.findDetailById(id);
        if (riskMapVO == null) {
            return null;
        }
        riskMapVO = generateRiskMapElement(riskMapVO);
        return riskMapVO;
    }

    @Transactional
    public BaseResponse deleteById(String id) throws RuntimeException {
        BaseResponse baseResponse = new BaseResponse<>();
        UserInfo curUser = ContextUtils.getLoginUser();
        if (StrUtil.isBlank(curUser.getOrgId())) {
            baseResponse.setCode(BaseStatusEnum.UN_DATA.code());
            baseResponse.setMsg("用户信息错误");
            return baseResponse;
        }
        String curUserOrgId = curUser.getOrgId();
        TSafeRiskMapDTO oldRiskMapDto = tSafeRiskMapRepo.findById(id);
        if (!curUserOrgId.equals(oldRiskMapDto.getOrgId())) {
            baseResponse.setCode(BaseStatusEnum.UNAUTHORIZED.code());
            baseResponse.setMsg("无权限操作");
            return baseResponse;
        }

        tSafeRiskMapRepo.deleteById(id);
        riskMapElementManageService.deleteByRiskBizId(id);
        return baseResponse;
    }

    // 组装查询 风险地图元素
    public TSafeRiskMapVO generateRiskMapElement(TSafeRiskMapVO riskMapVO) {
        if (StrUtil.isBlank(riskMapVO.getId())) {
            return null;
        }

        TSafeRiskMapElementDTOParam param = new TSafeRiskMapElementDTOParam();
        param.setStatus(BizConstants.STATUS_ENABLE);
        param.setMapId(riskMapVO.getId());
        List<TSafeRiskMapElementVO> riskMapElementVOList = riskMapElementManageService.listPage(param).getData();
        riskMapVO.setMapElementList(riskMapElementVOList);
        return riskMapVO;
    }

    /**
     * 列表不分页
     *
     * @param param
     * @return
     */
    public List<TSafeRiskMapDTO> listAll(TSafeRiskMapDTOParam param) {
        return tSafeRiskMapRepo.listAll(param);
    }

    /**
     * 检测 名称 是否都唯一
     * @return true - 唯一； false - 不唯一
     */
    public boolean checkUniqueness(String orgId, String sourceId, String name) {
        return riskMapService.checkUniqueness(orgId, sourceId, name);
    }

    public String orgAllPath(String orgId){
        if(StrUtil.isBlank(orgId)) {
            return null;
        }
        // 组装 组装机构全路径
        SysOrg org = orgService.getById(orgId);
        String orgAllPath = org.getParentIds() + "," + orgId;
        return orgAllPath;
    }
}
