package com.testor.module.accident.model.resp;

import com.testor.module.accident.model.domain.AccidentPersonnel;
import com.testor.module.accident.model.domain.AccidentReport;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @author zhangyangfan@testor.com.cn
 * @version 1.0
 * @description: 事故报告
 * @date 2022/5/11 11:43
 */
@EqualsAndHashCode(callSuper = true)
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel(value = "事故报告新增响应参数", description = "")
public class AccidentReportInsResp extends AccidentReport {

    @ApiModelProperty(value = "受伤人员")
    private List<AccidentPersonnel> accidentPersonnelList;
}
