package com.testor.module.accident.model.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @title AccidentReportQuery
 * @description <TODO description class purpose>
 * @Author: qiao
 * @version:1.0.0
 * @create：4/11/23 4:58 PM
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class AccidentReportQuery {
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    @TableId("id")
    private String id;
    /**
     * 关联ID
     */
    @ApiModelProperty(value = "关联ID")
    @TableField("ref_id")
    private String refId;
    /**
     * 父级ID
     */
    @ApiModelProperty(value = "父级ID")
    @TableField("parent_id")
    private String parentId;
    /**
     * 租户id
     */
    @ApiModelProperty(value = "租户id")
    @TableField("tenant_id")
    private String tenantId;
    /**
     * 流程实例ID
     */
    @ApiModelProperty(value = "流程实例ID")
    @TableField("process_id")
    private String processId;
    /**
     * 流程状态
     */
    @ApiModelProperty(value = "流程状态")
    @TableField("process_status")
    private String processStatus;
    /**
     * 上报单位
     */
    @ApiModelProperty(value = "上报单位")
    @TableField("report_unit")
    private String reportUnit;

    /**
     * 区域公司id
     */
    @ApiModelProperty(value = "区域公司id")
    @TableField("regional_company_id")
    private String regionalCompanyId;

    /**
     * 基层单位id
     */
    @ApiModelProperty(value = "基层单位id")
    @TableField("basic_unit_id")
    private String basicUnitId;

    /**
     * 事故时间
     */
    @ApiModelProperty(value = "事故时间")
    @TableField("accident_time")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date accidentTime;
    /**
     * 假日类型
     */
    @ApiModelProperty(value = "假日类型")
    @TableField("fake_type")
    private String fakeType;
    /**
     * 事故类型
     */
    @ApiModelProperty(value = "事故类型")
    @TableField("accident_type")
    private String accidentType;

    /**
     * 直接经济损失
     */
    @ApiModelProperty(value = "直接经济损失")
    @TableField("direct_economic_loss")
    private BigDecimal directEconomicLoss;

    /**
     * 间接经济损失
     */
    @ApiModelProperty(value = "间接经济损失")
    @TableField("indirect_economic_loss")
    private BigDecimal indirectEconomicLoss;

    /**
     * 合计经济损失
     */
    @ApiModelProperty(value = "合计经济损失")
    @TableField("total_economic_loss")
    private BigDecimal totalEconomicLoss;

    /**
     * 事故等级
     */
    @ApiModelProperty(value = "事故等级")
    @TableField("accident_level")
    private String accidentLevel;
    /**
     * 事故经过
     */
    @ApiModelProperty(value = "事故经过")
    @TableField("accident_passed")
    private String accidentPassed;
    /**
     * 事故原因
     */
    @ApiModelProperty(value = "事故原因")
    @TableField("accident_cause")
    private String accidentCause;
    /**
     * 改善措施
     */
    @ApiModelProperty(value = "改善措施")

    @TableField("improvements")
    private String improvements;
    /**
     * 附件
     */
    @ApiModelProperty(value = "附件")
    @TableField("attachment")
    private String attachment;

    /**
     * 消息通知类型
     */
    @ApiModelProperty(value = "消息通知类型")
    @TableField("receiver_type")
    private String receiverType;

    /**
     * 消息通知人
     */
    @ApiModelProperty(value = "消息通知人")
    @TableField("receiver_obj")
    private String receiverObj;

    /**
     * 驳回意见
     */
    @ApiModelProperty(value = "驳回意见")
    @TableField("reject_opinion")
    private String rejectOpinion;

    /**
     * 创建人部门id
     */
    @ApiModelProperty(value = "创建人部门id")
    @TableField("org_id")
    private String orgId;

    /**
     * 归属类型（本单位、相关方）
     */
    @ApiModelProperty(value = "归属类型（本单位、相关方）")
    @TableField("belong_type")
    private String belongType;

    /**
     * 归属单位
     */
    @ApiModelProperty(value = "归属单位")
    @TableField("belong_unit")
    private String belongUnit;

    @ApiModelProperty(value = "人员id")
    @TableField("user_id")
    private String userId;

    @ApiModelProperty(value = "姓名", example = "0")
    @TableField("user_name")
    private String userName;
    /**
     * 年龄
     */
    @ApiModelProperty(value = "年龄", example = "0")
    @TableField("age")
    private Long age;
    /**
     * 性别0男1女
     */
    @ApiModelProperty(value = "性别0男1女")
    @TableField("sex")
    private String sex;
}
