package com.testor.module.contractor.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum GeneralFlagEnum {
    YES("1", "是"),
    NO("0", "否");

    private String code;
    private String desc;

    public static GeneralFlagEnum getByCode(String code) {
        for (GeneralFlagEnum generalFlagEnum : GeneralFlagEnum.values()) {
            if (generalFlagEnum.getCode().equals(code)) {
                return generalFlagEnum;
            }
        }
        return null;
    }
}
