package com.testor.module.contractor.enums;

/**
 * 通用状态枚举，0-不通过，1-通过
 */
public enum GeneralStatusEnum {
    /**
     * -1-未知
     */
    UNKNOWN("-1", "未知"),

    /**
     * 0-不通过
     */
    UNPASSED("0", "不通过"),

    /**
     * 1-通过
     */
    PASSED("1", "通过");

    private String code;
    private String desc;

    GeneralStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
