package com.testor.module.contractor.ledger.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 承包商合同对象 t_contractor_contract
 * 
 * @author testor-framework
 * @date 2024-11-19 10:20:52
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_contract")
@ApiModel(value = "TContractorContract对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorContract extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键ID
 */
  @ApiModelProperty(value = "主键ID")

  @TableId("id")
  private String id;
/**
 * 承包商ID
 */
  @ApiModelProperty(value = "承包商ID")

  @TableField("contractor_id")
  private String contractorId;
/**
 * 合同名称
 */
  @ApiModelProperty(value = "合同名称")

  @TableField("contract_name")
  private String contractName;
/**
 * 企业名称
 */
  @ApiModelProperty(value = "企业名称")

  @TableField("company_name")
  private String companyName;
/**
 * 合同有效期起
 */
  @ApiModelProperty(value = "合同有效期起")

  @TableField("valid_start_date")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date validStartDate;
/**
 * 合同有效期止
 */
  @ApiModelProperty(value = "合同有效期止")

  @TableField("valid_end_date")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date validEndDate;
/**
 * 附件，存文件id
 */
  @ApiModelProperty(value = "附件，存文件id")

  @TableField("attachment")
  private String attachment;

  @ApiModelProperty("附件url")
  @TableField(exist = false)
  private String attachmentUrl;

  public static final String ID ="id";
  public static final String CONTRACTOR_ID ="contractor_id";
  public static final String CONTRACT_NAME ="contract_name";
  public static final String COMPANY_NAME ="company_name";
  public static final String VALID_START_DATE ="valid_start_date";
  public static final String VALID_END_DATE ="valid_end_date";
  public static final String ATTACHMENT ="attachment";


}
