package com.testor.module.contractor.ledger.model.domain;

import java.time.LocalDateTime;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.testor.common.annotation.Translation;
import com.testor.common.constant.TransConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import org.springframework.format.annotation.DateTimeFormat;


/**
 * 人员资质关系对象 t_contractor_person_certificate
 * 
 * @author testor-framework
 * @date 2024-11-22 09:55:04
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_person_certificate")
@ApiModel(value = "TContractorPersonCertificate对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorPersonCertificate extends SuperModel
{
    private static final long serialVersionUID = 1L;

  @TableId("id")
  private String id;

  /**
   * 证书名称
   */
  @ApiModelProperty(value = "人员id")

  @TableField("person_id")
  private String personId;

/**
 * 证书名称
 */
  @ApiModelProperty(value = "证书名称")

  @TableField("name")
  private String name;
/**
 * 特种作业工种 字典id
 */
  @ApiModelProperty(value = "特种作业工种 字典id")

  @TableField("special_work_type")
  private String specialWorkType;


  @TableField(exist = false)
  @Translation(type = TransConstant.DICT_ID_TO_LABEL,mapper = "specialWorkType")
  private String specialWorkTypeName;

/**
 * 证书编号
 */
  @ApiModelProperty(value = "证书编号")

  @TableField("code")
  private String code;
/**
 * 证件有效期起
 */
  @ApiModelProperty(value = "证件有效期起")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @TableField("start_date")
  private Date startDate;
/**
 * 证件有效期止
 */
  @ApiModelProperty(value = "证件有效期止")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @TableField("end_date")
  private Date endDate;
/**
 * 取证/复审
 */
  @ApiModelProperty(value = "取证/复审")

  @TableField("certification_or_review")
  private String certificationOrReview;
/**
 * 复审日期
 */
  @ApiModelProperty(value = "复审日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @TableField("review_date")
  private Date reviewDate;
/**
 * 是否复审完成 0否 1是
 */
  @ApiModelProperty(value = "是否复审完成 0否 1是")

  @TableField("is_review_completed")
  private String isReviewCompleted;

  @Translation(mapper = "isReviewCompleted",other = "0=否,1=是")
  @TableField(exist = false)
  private String isReviewCompletedName;
/**
 * 发证机构
 */
  @ApiModelProperty(value = "发证机构")

  @TableField("issuing_authority")
  private String issuingAuthority;
/**
 * 办理名称
 */
  @ApiModelProperty(value = "办理名称")

  @TableField("process_name")
  private String processName;
/**
 * 证件保管
 */
  @ApiModelProperty(value = "证件保管")

  @TableField("document_storage")
  private String documentStorage;
/**
 * 附件
 */
  @ApiModelProperty(value = "附件")

  @TableField("attachment")
  private String attachment;
/**
 * 安全员证
 */
  @ApiModelProperty(value = "安全员证")

  @TableField("safety_officer_certificate")
  private String safetyOfficerCertificate;
/**
 * 安全管理人员资格证
 */
  @ApiModelProperty(value = "安全管理人员资格证")

  @TableField("safety_management_certificate")
  private String safetyManagementCertificate;

  public static final String ID ="id";
  public static final String PERSON_ID ="person_id";
  public static final String NAME ="name";
  public static final String SPECIAL_WORK_TYPE ="special_work_type";
  public static final String CODE ="code";
  public static final String START_DATE ="start_date";
  public static final String END_DATE ="end_date";
  public static final String CERTIFICATION_OR_REVIEW ="certification_or_review";
  public static final String REVIEW_DATE ="review_date";
  public static final String IS_REVIEW_COMPLETED ="is_review_completed";
  public static final String ISSUING_AUTHORITY ="issuing_authority";
  public static final String PROCESS_NAME ="process_name";
  public static final String DOCUMENT_STORAGE ="document_storage";
  public static final String ATTACHMENT ="attachment";
  public static final String SAFETY_OFFICER_CERTIFICATE ="safety_officer_certificate";
  public static final String SAFETY_MANAGEMENT_CERTIFICATE ="safety_management_certificate";


}
