package com.testor.module.contractor.manage.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.contractor.manage.model.domain.TContractorDailyPlanChange;
import com.testor.module.contractor.manage.model.dto.TContractorDailyPlanChangeParam;
import com.testor.module.contractor.manage.model.dto.TContractorDailyPlanChangeDelParam;
import com.testor.module.contractor.manage.service.TContractorDailyPlanChangeService;

/**
 * 日常管理-每日工作计划-变更Controller
 *
 * @author testor-framework
 * @date 2024-11-29 10:10:44
 */
@RestController
@RequestMapping("/manage/change")
@Api(value = "TContractorDailyPlanChange", tags = "日常管理-每日工作计划-变更")
@Slf4j
public class TContractorDailyPlanChangeController extends SuperController
{
    @Autowired
    private TContractorDailyPlanChangeService tContractorDailyPlanChangeService;

    /* Generated Method*/
	@ApiOperation(value = "新增 日常管理-每日工作计划-变更", notes = "Add TContractorDailyPlanChange")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorDailyPlanChange>addEntity(@RequestBody TContractorDailyPlanChange addRequest) {
		BaseResponse<TContractorDailyPlanChange> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TContractorDailyPlanChange data=BeanHelper.beanToBean(addRequest,  TContractorDailyPlanChange.class);
			data.setId(id);
			tContractorDailyPlanChangeService.removeById(addRequest.getPlanId());
			boolean result= tContractorDailyPlanChangeService.save(data);
			if(result){
                TContractorDailyPlanChange newEntity = new TContractorDailyPlanChange();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理-每日工作计划-变更 ", notes = "Get TContractorDailyPlanChange By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorDailyPlanChange> getById(String id){
		BaseResponse<TContractorDailyPlanChange> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TContractorDailyPlanChange data= tContractorDailyPlanChangeService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 日常管理-每日工作计划-变更 ", notes = "Update TContractorDailyPlanChange By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorDailyPlanChange updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorDailyPlanChange data=BeanHelper.beanToBean(updateRequest, TContractorDailyPlanChange.class);
			boolean result= tContractorDailyPlanChangeService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 日常管理-每日工作计划-变更 ", notes = "delete TContractorDailyPlanChange By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorDailyPlanChangeDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorDailyPlanChange data= new TContractorDailyPlanChange();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tContractorDailyPlanChangeService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除日常管理-每日工作计划-变更", notes = "delete TContractorDailyPlanChange by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorDailyPlanChangeDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorDailyPlanChange> tContractorDailyPlanChangeList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorDailyPlanChange data= new TContractorDailyPlanChange();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorDailyPlanChangeList.add(data);
			}
			boolean result = tContractorDailyPlanChangeService.updateBatchById(tContractorDailyPlanChangeList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理-每日工作计划-变更 分页列表", notes = "List TContractorDailyPlanChange with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorDailyPlanChange>>listEntity(TContractorDailyPlanChangeParam param){
		BaseResponse<BaseResponseList<TContractorDailyPlanChange>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TContractorDailyPlanChange> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorDailyPlanChange> queryWrapper=this.createQuery(param);
		Page<TContractorDailyPlanChange> resultList= tContractorDailyPlanChangeService.page(resultPage,queryWrapper);
		BaseResponseList<TContractorDailyPlanChange> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理-每日工作计划-变更 列表", notes = "List TContractorDailyPlanChange all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorDailyPlanChange>>listAllEntity(TContractorDailyPlanChangeParam param){
		BaseResponse<BaseResponseList<TContractorDailyPlanChange>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorDailyPlanChange> queryWrapper=this.createQuery(param);
		List<TContractorDailyPlanChange> resultList=tContractorDailyPlanChangeService.list(queryWrapper);
		BaseResponseList<TContractorDailyPlanChange> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TContractorDailyPlanChange> createQuery(TContractorDailyPlanChangeParam queryParam){
		QueryWrapper<TContractorDailyPlanChange> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getPlanId())){
			queryWrapper.eq(TContractorDailyPlanChange.PLAN_ID,queryParam.getPlanId());
		}
		if(StringHelper.isNotEmpty(queryParam.getType())){
			queryWrapper.eq(TContractorDailyPlanChange.TYPE,queryParam.getType());
		}
		if(StringHelper.isNotEmpty(queryParam.getProcessId())){
			queryWrapper.eq(TContractorDailyPlanChange.PROCESS_ID,queryParam.getProcessId());
		}
		if(StringHelper.isNotEmpty(queryParam.getProcessStatus())){
			queryWrapper.eq(TContractorDailyPlanChange.PROCESS_STATUS,queryParam.getProcessStatus());
		}
		if(StringHelper.isNotEmpty(queryParam.getOrgId())){
			queryWrapper.eq(TContractorDailyPlanChange.ORG_ID,queryParam.getOrgId());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getApplyTime())){
			queryWrapper.eq(TContractorDailyPlanChange.APPLY_TIME,queryParam.getApplyTime());
		}
		if(StringHelper.isNotEmpty(queryParam.getChangeLevelId())){
			queryWrapper.eq(TContractorDailyPlanChange.CHANGE_LEVEL_ID,queryParam.getChangeLevelId());
		}
		if(StringHelper.isNotEmpty(queryParam.getChangeLevel())){
			queryWrapper.eq(TContractorDailyPlanChange.CHANGE_LEVEL,queryParam.getChangeLevel());
		}
		if(StringHelper.isNotEmpty(queryParam.getChangeTypeId())){
			queryWrapper.eq(TContractorDailyPlanChange.CHANGE_TYPE_ID,queryParam.getChangeTypeId());
		}
		if(StringHelper.isNotEmpty(queryParam.getChangeType())){
			queryWrapper.eq(TContractorDailyPlanChange.CHANGE_TYPE,queryParam.getChangeType());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getWorkStartTime())){
			queryWrapper.eq(TContractorDailyPlanChange.WORK_START_TIME,queryParam.getWorkStartTime());
		}
		if(ObjectHelper.isNotEmpty(queryParam.getWorkFinishTime())){
			queryWrapper.eq(TContractorDailyPlanChange.WORK_FINISH_TIME,queryParam.getWorkFinishTime());
		}
		if(StringHelper.isNotEmpty(queryParam.getReason())){
			queryWrapper.eq(TContractorDailyPlanChange.REASON,queryParam.getReason());
		}
		if(StringHelper.isNotEmpty(queryParam.getWorkContent())){
			queryWrapper.eq(TContractorDailyPlanChange.WORK_CONTENT,queryParam.getWorkContent());
		}
		if(StringHelper.isNotEmpty(queryParam.getRiskType())){
			queryWrapper.eq(TContractorDailyPlanChange.RISK_TYPE,queryParam.getRiskType());
		}
		if(StringHelper.isNotEmpty(queryParam.getMeasure())){
			queryWrapper.eq(TContractorDailyPlanChange.MEASURE,queryParam.getMeasure());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TContractorDailyPlanChange.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TContractorDailyPlanChange.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TContractorDailyPlanChange.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
