package com.testor.module.contractor.manage.controller;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import lombok.extern.slf4j.Slf4j;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.exceptions.ApiException;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.IdHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;

import com.testor.module.contractor.manage.model.domain.TContractorDailyPlanInspectResultHazard;
import com.testor.module.contractor.manage.model.dto.TContractorDailyPlanInspectResultHazardParam;
import com.testor.module.contractor.manage.model.dto.TContractorDailyPlanInspectResultHazardDelParam;
import com.testor.module.contractor.manage.service.TContractorDailyPlanInspectResultHazardService;

/**
 * 日常管理-每日工作计划-检查结果-隐患关联Controller
 *
 * @author testor-framework
 * @date 2024-11-30 15:43:18
 */
@RestController
@RequestMapping("/manage/hazard")
@Api(value = "TContractorDailyPlanInspectResultHazard", tags = "日常管理-每日工作计划-检查结果-隐患关联")
@Slf4j
public class TContractorDailyPlanInspectResultHazardController extends SuperController
{
    @Autowired
    private TContractorDailyPlanInspectResultHazardService tContractorDailyPlanInspectResultHazardService;

    /* Generated Method*/
	@ApiOperation(value = "新增 日常管理-每日工作计划-检查结果-隐患关联", notes = "Add TContractorDailyPlanInspectResultHazard")
	@PostMapping(value = "/add")
	public BaseResponse<TContractorDailyPlanInspectResultHazard>addEntity(@RequestBody TContractorDailyPlanInspectResultHazard addRequest) {
		BaseResponse<TContractorDailyPlanInspectResultHazard> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(addRequest)){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
			String id = IdHelper.getId32bit();
            TContractorDailyPlanInspectResultHazard data=BeanHelper.beanToBean(addRequest,  TContractorDailyPlanInspectResultHazard.class);
			data.setId(id);
			boolean result= tContractorDailyPlanInspectResultHazardService.save(data);
			if(result){
                TContractorDailyPlanInspectResultHazard newEntity = new TContractorDailyPlanInspectResultHazard();
				newEntity.setId(id);
				baseResponse.setData(newEntity);
			}
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理-每日工作计划-检查结果-隐患关联 ", notes = "Get TContractorDailyPlanInspectResultHazard By Id")
	@GetMapping(value = "/get")
	public BaseResponse<TContractorDailyPlanInspectResultHazard> getById(String id){
		BaseResponse<TContractorDailyPlanInspectResultHazard> baseResponse=new BaseResponse<>();
		if(StringHelper.isNotEmpty(id)){
			// TODO 按需求添加业务异常判断
            TContractorDailyPlanInspectResultHazard data= tContractorDailyPlanInspectResultHazardService.getById(id);
			baseResponse.setData(data);
		}
		return baseResponse;
	}

	@ApiOperation(value = "修改 日常管理-每日工作计划-检查结果-隐患关联 ", notes = "Update TContractorDailyPlanInspectResultHazard By Id")
	@PutMapping(value = "/update")
	public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContractorDailyPlanInspectResultHazard updateRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(updateRequest)&&StringHelper.isNotEmpty(updateRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorDailyPlanInspectResultHazard data=BeanHelper.beanToBean(updateRequest, TContractorDailyPlanInspectResultHazard.class);
			boolean result= tContractorDailyPlanInspectResultHazardService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "删除 日常管理-每日工作计划-检查结果-隐患关联 ", notes = "delete TContractorDailyPlanInspectResultHazard By Id")
	@PutMapping(value = "/delete")
	public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContractorDailyPlanInspectResultHazardDelParam deleteRequest){
		BaseResponse<BizGeneralResponse> baseResponse=new BaseResponse<>();
		if(ObjectHelper.isNotEmpty(deleteRequest)&&StringHelper.isNotEmpty(deleteRequest.getId())){
			// TODO 按需求添加数据去重，特殊值设定，业务异常
            TContractorDailyPlanInspectResultHazard data= new TContractorDailyPlanInspectResultHazard();
			data.setId(deleteRequest.getId());
			data.setStatus(BizConstants.STATUS_DELETE);
			boolean result= tContractorDailyPlanInspectResultHazardService.updateById(data);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "批量删除日常管理-每日工作计划-检查结果-隐患关联", notes = "delete TContractorDailyPlanInspectResultHazard by batch Id")
	@PutMapping(value = "/batch_delete")
	public BaseResponse<BizGeneralResponse> deleteEntityBatch(
			@RequestBody TContractorDailyPlanInspectResultHazardDelParam deleteRequest) {
		BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
		if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
			List<TContractorDailyPlanInspectResultHazard> tContractorDailyPlanInspectResultHazardList = new ArrayList<>();
            for(String id: deleteRequest.getIds()){
                TContractorDailyPlanInspectResultHazard data= new TContractorDailyPlanInspectResultHazard();
				data.setId(id);
				data.setStatus(BizConstants.STATUS_DELETE);
                tContractorDailyPlanInspectResultHazardList.add(data);
			}
			boolean result = tContractorDailyPlanInspectResultHazardService.updateBatchById(tContractorDailyPlanInspectResultHazardList);
			baseResponse.setData(
					BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
		}
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理-每日工作计划-检查结果-隐患关联 分页列表", notes = "List TContractorDailyPlanInspectResultHazard with page")
	@GetMapping(value = "/list")
	public  BaseResponse<BaseResponseList<TContractorDailyPlanInspectResultHazard>>listEntity(TContractorDailyPlanInspectResultHazardParam param){
		BaseResponse<BaseResponseList<TContractorDailyPlanInspectResultHazard>>baseResponse=new BaseResponse<>();
		Long page=
				StringHelper.isEmpty(param.getPage())?BizConstants.PAGE:Long.valueOf(param.getPage());
		Long limit=
				StringHelper.isEmpty(param.getLimit())?BizConstants.LIMIT:Long.valueOf(param.getLimit());
		Page<TContractorDailyPlanInspectResultHazard> resultPage=new Page<>(page,limit);
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorDailyPlanInspectResultHazard> queryWrapper=this.createQuery(param);
		Page<TContractorDailyPlanInspectResultHazard> resultList= tContractorDailyPlanInspectResultHazardService.page(resultPage,queryWrapper);
		BaseResponseList<TContractorDailyPlanInspectResultHazard> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList.getRecords());
		baseResponseList.setTotal(resultList.getTotal());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

	@ApiOperation(value = "获取 日常管理-每日工作计划-检查结果-隐患关联 列表", notes = "List TContractorDailyPlanInspectResultHazard all")
	@GetMapping(value = "/datas")
	public  BaseResponse<BaseResponseList<TContractorDailyPlanInspectResultHazard>>listAllEntity(TContractorDailyPlanInspectResultHazardParam param){
		BaseResponse<BaseResponseList<TContractorDailyPlanInspectResultHazard>>baseResponse=new BaseResponse<>();
		// TODO 根据需求修改查询条件及查询参数
		QueryWrapper<TContractorDailyPlanInspectResultHazard> queryWrapper=this.createQuery(param);
		List<TContractorDailyPlanInspectResultHazard> resultList=tContractorDailyPlanInspectResultHazardService.list(queryWrapper);
		BaseResponseList<TContractorDailyPlanInspectResultHazard> baseResponseList=new BaseResponseList<>();
		baseResponseList.setData(resultList);
		baseResponseList.setTotal(resultList.size());
		baseResponse.setData(baseResponseList);
		return baseResponse;
	}

    /* Private Methods */
	/**
     * 列表查询条件及查询参数
     */
	private QueryWrapper<TContractorDailyPlanInspectResultHazard> createQuery(TContractorDailyPlanInspectResultHazardParam queryParam){
		QueryWrapper<TContractorDailyPlanInspectResultHazard> queryWrapper=new QueryWrapper<>();
		if(StringHelper.isNotEmpty(queryParam.getInspectId())){
			queryWrapper.eq(TContractorDailyPlanInspectResultHazard.INSPECT_ID,queryParam.getInspectId());
		}
		if(StringHelper.isNotEmpty(queryParam.getInspectResultId())){
			queryWrapper.eq(TContractorDailyPlanInspectResultHazard.INSPECT_RESULT_ID,queryParam.getInspectResultId());
		}
		if(StringHelper.isNotEmpty(queryParam.getPlanId())){
			queryWrapper.eq(TContractorDailyPlanInspectResultHazard.PLAN_ID,queryParam.getPlanId());
		}
		if(StringHelper.isNotEmpty(queryParam.getHazardId())){
			queryWrapper.eq(TContractorDailyPlanInspectResultHazard.HAZARD_ID,queryParam.getHazardId());
		}
		if (StringHelper.isNotEmpty(queryParam.getStatus())) {
			queryWrapper.eq(TContractorDailyPlanInspectResultHazard.STATUS, queryParam.getStatus());
		} else {
			queryWrapper.ne(TContractorDailyPlanInspectResultHazard.STATUS, BizConstants.STATUS_DELETE);
		}
		if (StringHelper.isNotEmpty(queryParam.getOrderBy())){
			if(StringHelper.isNotEmpty(queryParam.getOrderType())
					&&BizConstants.ASC.equals(queryParam.getOrderType())){
				queryWrapper.orderByAsc(queryParam.getOrderBy());
			}else{
				queryWrapper.orderByDesc(queryParam.getOrderBy());
			}
		}else{
			queryWrapper.orderByDesc(TContractorDailyPlanInspectResultHazard.UPDATE_DATE);
		}
		return queryWrapper;
	}
}
