package com.testor.module.contractor.manage.model.domain;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;


/**
 * 承包商管理-安全交底-交底内容对象 t_contractor_safety_brief_detail
 * 
 * @author testor-framework
 * @date 2024-11-28 11:38:01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contractor_safety_brief_detail")
@ApiModel(value = "TContractorSafetyBriefDetail对象" , description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContractorSafetyBriefDetail extends SuperModel
{
    private static final long serialVersionUID = 1L;
/**
 * 主键id
 */
  @ApiModelProperty(value = "主键id")

  @TableId("id")
  private String id;
/**
 * 交底id
 */
  @ApiModelProperty(value = "交底id")

  @TableField("brief_id")
  private String briefId;
/**
 * 承包商台账id
 */
  @ApiModelProperty(value = "承包商台账id")

  @TableField("contractor_id")
  private String contractorId;
/**
 * 项目id
 */
  @ApiModelProperty(value = "项目id")

  @TableField("proj_id")
  private String projId;
/**
 * 业务id(标识是一条基本信息产生的关系)
 */
  @ApiModelProperty(value = "业务id(标识是一条基本信息产生的关系)")

  @TableField("biz_id")
  private String bizId;
/**
 * 交底内容
 */
  @ApiModelProperty(value = "交底内容")

  @TableField("content")
  private String content;
/**
 * 其他内容
 */
  @ApiModelProperty(value = "其他内容")

  @TableField("other_content")
  private String otherContent;
/**
 * 交底项编号
 */
  @ApiModelProperty(value = "交底项编号")

  @TableField("code")
  private String code;
/**
 * 交底状态：0不通过 1通过
 */
  @ApiModelProperty(value = "交底状态：0不通过 1通过")

  @TableField("brief_status")
  private String briefStatus;
/**
 * 序号
 */
  @ApiModelProperty(value = "序号" , example = "0")

  @TableField("tree_sort")
  private BigDecimal treeSort;

  @ApiModelProperty(value = "附件")
  @TableField("attachment")
  private String attachment;

  public static final String ID ="id";
  public static final String BRIEF_ID ="brief_id";
  public static final String CONTRACTOR_ID ="contractor_id";
  public static final String PROJ_ID ="proj_id";
  public static final String BIZ_ID ="biz_id";
  public static final String CONTENT ="content";
  public static final String OTHER_CONTENT ="other_content";
  public static final String CODE ="code";
  public static final String BRIEF_STATUS ="brief_status";
  public static final String TREE_SORT ="tree_sort";
  public static final String ATTACHMENT ="attachment";


}
