package com.testor.module.contractor.manage.model.template;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 开工准备-风险分析和控制措施导入模板
 */
@Data
public class PreparationAnalysisTemplate {
    /**
     * 工作场所
     */
    @ExcelProperty(value = "工作场所",index = 0)
    @ColumnWidth(value = 20)
    private String workplace;
    /**
     * 活动名称
     */
    @ExcelProperty(value = "活动名称",index = 1)
    @ColumnWidth(value = 20)
    private String activityName;
    /**
     * 危险源描述
     */
    @ExcelProperty(value = "危险源描述",index = 2)
    @ColumnWidth(value = 20)
    private String hazardDescription;
    /**
     * 可能导致的后果
     */
    @ExcelProperty(value = "可能导致的后果",index = 3)
    @ColumnWidth(value = 20)
    private String potentialAccidentConsequences;
    /**
     * 控制措施
     */
    @ExcelProperty(value = "控制措施", index = 4)
    @ColumnWidth(value = 20)
    private String controlMeasures;
}
