package com.testor.module.duty.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.testor.module.duty.model.domain.TSysDuty;
import com.testor.module.duty.model.domain.TSysDutyMonth;
import com.testor.module.duty.model.domain.TSysDutyalter;
import com.testor.module.duty.model.dto.Duty;
import com.testor.module.duty.model.dto.Person;
import com.testor.module.duty.model.po.ExportDutyPo;
import com.testor.module.duty.model.po.ExportPo;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

public interface DutyService extends IService<TSysDuty> {
    //保存值班数据
    BaseResponse add(List<Duty> duty) throws Exception;

    //批量导入值班数据
    BaseResponse<List<Person>> imports(MultipartFile file, TSysDuty tSysDuty) throws Exception;

    //单日添加值班人员信息
    BaseResponse inserts(TSysDuty tSysDuty) throws Exception;

    //修改值班人员
    BaseResponse update(TSysDuty tSysDuty) throws Exception;

    //删除值班人员
    BaseResponse delete(TSysDuty tSysDuty) throws Exception;

    //获取值班日历列表
//    BaseResponse<List<PersonDuty>> getLists(TSysDutyMonth tSysDutyMonth) throws Exception;
    BaseResponse<List<Duty>> getLists(TSysDutyMonth tSysDutyMonth) throws Exception;

    //审核状态修改接口
    BaseResponse auditUpdate(TSysDutyalter tSysDutyalter) throws Exception;

    // 编辑的时候用于数据回显
    BaseResponse auditEcho(Person person) throws Exception;

    //值班列表单个添加人审批状态修改
    BaseResponse dutyAddOne(TSysDuty tSysDuty);

    BaseResponse<List<Duty>> getDutyList(String id)throws Exception;

    BaseResponse updateByDuty(TSysDuty tSysDuty)throws Exception;

    BaseResponse deleteDuty(String id);

    BaseResponse<List<TSysDuty>> getHomeDuty(String orgId);

    /**
     * 导出值班记录
     * @param tSysDutyMonth
     * @return
     */
    List<ExportPo> downloadDutyLog(TSysDutyMonth tSysDutyMonth);

    void exportDuty(TSysDutyMonth tSysDuty, HttpServletResponse response);

    BaseResponse<TSysDutyMonth> getDutyMonth(String id);
}