package com.testor.module.emergency.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.emergency.model.del.TContingencyPlanDelParam;
import com.testor.module.emergency.model.domain.TContingencyPlan;
import com.testor.module.emergency.model.dto.TContingencyPlanDTO;
import com.testor.module.emergency.model.dto.TContingencyPlanParam;
import com.testor.module.emergency.model.vo.TContingency;
import com.testor.module.emergency.model.vo.TContingencyPlanRecordVO;
import com.testor.module.emergency.model.vo.TContingencyPlanVO;
import com.testor.module.emergency.service.TContingencyPlanService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;


/**
 * 应急预案Controller
 *
 * @author testor-framework
 * @date 2022-10-18 09:50:43
 */
@RestController
@RequestMapping("/emergency/plan")
@Api(value = "TContingencyPlan", tags = "应急预案")
@Slf4j
public class TContingencyPlanController extends SuperController {
    @Autowired
    private TContingencyPlanService tContingencyPlanService;

    /* Generated Method*/
    @ApiOperation(value = "新增和修改应急预案", notes = "Add TContingencyPlan")
    @PostMapping(value = "/addAndUpdate")
    public BaseResponse<BizGeneralResponse> addEntity(@RequestBody TContingencyPlanDTO tContingencyPlanDTO) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(tContingencyPlanDTO)) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常

            Boolean result = tContingencyPlanService.addEntity(tContingencyPlanDTO);

            baseResponse.setData(BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());

        }
        return baseResponse;
    }

    @ApiOperation(value = "获取应急预案详情 ", notes = "Get TContingencyPlan By Id")
    @GetMapping(value = "/get/particulars")
    public BaseResponse<TContingency> getParticulars(String id) {
        BaseResponse<TContingency> baseResponse = new BaseResponse<>();
        if (StringHelper.isNotEmpty(id)) {
            // TODO 按需求添加业务异常判断
            TContingency data = tContingencyPlanService.getParticulars(id);
            baseResponse.setData(data);
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取应急预案修订记录 ", notes = "Get TContingencyPlan By Id")
    @GetMapping(value = "/get/edit_history")
    public BaseResponse<List<TContingencyPlanRecordVO>> getEditHistory(String id) {
        BaseResponse<List<TContingencyPlanRecordVO>> baseResponse = new BaseResponse<>();
        if (StringHelper.isNotEmpty(id)) {
            // TODO 按需求添加业务异常判断
            List<TContingencyPlanRecordVO> data = tContingencyPlanService.getEditHistory(id);
            baseResponse.setData(data);
        }
        return baseResponse;
    }

    @ApiOperation(value = "修改 应急预案 ", notes = "Update TContingencyPlan By Id")
    @PutMapping(value = "/update")
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TContingencyPlan updateRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(updateRequest) && StringHelper.isNotEmpty(updateRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TContingencyPlan data = BeanHelper.beanToBean(updateRequest, TContingencyPlan.class);
            boolean result = tContingencyPlanService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "删除 应急预案 ", notes = "delete TContingencyPlan By Id")
    @PutMapping(value = "/delete")
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TContingencyPlanDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && StringHelper.isNotEmpty(deleteRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TContingencyPlan data = new TContingencyPlan();
            data.setId(deleteRequest.getId());
            data.setStatus(BizConstants.STATUS_DELETE);
            boolean result = tContingencyPlanService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "批量删除应急预案", notes = "delete TContingencyPlan by batch Id")
    @PutMapping(value = "/batch_delete")
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(
            @RequestBody TContingencyPlanDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
            List<TContingencyPlan> tContingencyPlanList = new ArrayList<>();
            for (String id : deleteRequest.getIds()) {
                TContingencyPlan data = new TContingencyPlan();
                data.setId(id);
                data.setStatus(BizConstants.STATUS_DELETE);
                tContingencyPlanList.add(data);
            }
            boolean result = tContingencyPlanService.updateBatchById(tContingencyPlanList);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 应急预案 分页列表", notes = "List TContingencyPlan with page")
    @PostMapping(value = "/list")
    public BaseResponse<BaseResponseList<TContingencyPlanVO>> listEntity(@RequestBody TContingencyPlanParam param) {
        BaseResponse<BaseResponseList<TContingencyPlanVO>> baseResponse = new BaseResponse<>();
        Page<TContingencyPlanVO> resultList = tContingencyPlanService.pageList(param);
        BaseResponseList<TContingencyPlanVO> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value = "获取 应急预案 分组", notes = "")
    @GetMapping(value = "/list")
    public BaseResponse<List<TContingencyPlanVO>> listEntity(String simulationEventType) {
        BaseResponse<List<TContingencyPlanVO>> baseResponse = new BaseResponse<>();
        List<TContingencyPlanVO> resultList = tContingencyPlanService.listEntity(simulationEventType);
        baseResponse.setData(resultList);
        return baseResponse;
    }


    /* Private Methods */

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TContingencyPlan> createQuery(TContingencyPlanParam queryParam) {
        QueryWrapper<TContingencyPlan> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getPlanName())) {
            queryWrapper.like(TContingencyPlan.PLAN_NAME, queryParam.getPlanName());
        }
        if (StringHelper.isNotEmpty(queryParam.getPlanTypeKey())) {
            queryWrapper.eq(TContingencyPlan.PLAN_TYPE_KEY, queryParam.getPlanTypeKey());
        }
        if (StringHelper.isNotEmpty(queryParam.getAccidentKey())) {
            queryWrapper.eq(TContingencyPlan.ACCIDENT_KEY, queryParam.getAccidentKey());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getReviseTime())) {
            queryWrapper.eq(TContingencyPlan.REVISE_TIME, queryParam.getReviseTime());
        }
        if (ObjectHelper.isNotEmpty(queryParam.getDisabledTime())) {
            queryWrapper.eq(TContingencyPlan.DISABLED_TIME, queryParam.getDisabledTime());
        }
        if (StringHelper.isNotEmpty(queryParam.getOrgId())) {
            queryWrapper.eq(TContingencyPlan.ORG_ID, queryParam.getOrgId());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TContingencyPlan.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TContingencyPlan.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TContingencyPlan.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
