package com.testor.module.emergency.model.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.tongtech.tfw.backend.common.models.supers.SuperModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import lombok.experimental.SuperBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;


/**
 * 应急预案对象 t_contingency_plan
 *
 * @author testor-framework
 * @date 2022-10-18 09:50:43
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("t_contingency_plan")
@ApiModel(value = "TContingencyPlan对象", description = "")
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class TContingencyPlan extends SuperModel {
    private static final long serialVersionUID = 1L;
    /**
     * 预案名称
     */
    @ApiModelProperty(value = "预案名称")

    @TableField("plan_name")
    private String planName;
    /**
     * 预案类型对应字典key
     */
    @ApiModelProperty(value = "预案类型对应字典key")

    @TableField("plan_type_key")
    private String planTypeKey;
    /**
     * 事故类型对应字典key
     */
    @ApiModelProperty(value = "事故类型对应字典key")

    @TableField("accident_key")
    private String accidentKey;
    /**
     * 修订时间
     */
    @ApiModelProperty(value = "修订时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("revise_time")
    private Date reviseTime;
    /**
     * 失效时间
     */
    @ApiModelProperty(value = "失效时间")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("disabled_time")
    private Date disabledTime;
    /**
     * id
     */
    @ApiModelProperty(value = "id")

    @TableId("id")
    private String id;
    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "组织机构id")

    @TableField("org_id")
    private String orgId;


    public static final String PLAN_NAME = "plan_name";
    public static final String PLAN_TYPE_KEY = "plan_type_key";
    public static final String ACCIDENT_KEY = "accident_key";
    public static final String REVISE_TIME = "revise_time";
    public static final String DISABLED_TIME = "disabled_time";
    public static final String ID = "id";
    public static final String ORG_ID = "org_id";


}
