package com.testor.module.emergency.service.impl;


import com.testor.module.emergency.dao.TContingencyPlanContentDao;
import com.testor.module.emergency.model.domain.TContingencyPlanContent;
import com.testor.module.emergency.model.vo.TContingencyPlanContentVO;
import com.testor.module.emergency.service.TContingencyPlanContentService;
import com.tongtech.tfw.backend.common.models.supers.SuperServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 应急预案应急工作组及工作内容Service业务层处理
 *
 * @author testor-framework
 * @date 2022-10-18 10:07:39
 */
@Service
public class TContingencyPlanContentServiceImpl extends SuperServiceImpl<TContingencyPlanContentDao, TContingencyPlanContent> implements TContingencyPlanContentService {
    @Autowired(required = false)
    private TContingencyPlanContentDao tContingencyPlanContentDao;

    @Override
    public List<TContingencyPlanContentVO> getList(String id) {
        return tContingencyPlanContentDao.getList(id).stream().sorted(Comparator.comparing(TContingencyPlanContentVO::getGroupName)
                .thenComparing(TContingencyPlanContentVO::getName).thenComparing(TContingencyPlanContent::getGroundWork))
                .collect(Collectors.toList());
    }
}
