package com.testor.module.emergency.task;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.testor.common.util.SpringBeanFactory;
import com.testor.module.emergency.model.domain.TEmergencyRehearsal;
import com.testor.module.emergency.service.TEmergencyRehearsalService;
import com.testor.module.messageNotice.model.domain.TMsgNotice;
import com.testor.module.messageNotice.model.vo.MsgTemplateVO;
import com.testor.module.messageNotice.service.TMsgNoticeService;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.task.service.delegate.DelegateTask;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class SafeTaskListener implements TaskListener {
    private final TMsgNoticeService tMsgNoticeService;
    private final TEmergencyRehearsalService tEmergencyRehearsalService;
    public SafeTaskListener() {
        this.tMsgNoticeService = SpringBeanFactory.getBean(TMsgNoticeService.class);
        this.tEmergencyRehearsalService =SpringBeanFactory.getBean(TEmergencyRehearsalService.class);
    }





    @Override
    public void notify(DelegateTask delegateTask) {
        Map<String, Object> variablesLocal = delegateTask.getVariablesLocal();
        // 节点名称
        String name = delegateTask.getName();
        // 消息类型
        String templateType = String.valueOf(variablesLocal.get("templateType"));
        // 隐患名称
        String safeName = String.valueOf(variablesLocal.get("name"));
        // 流程状态
        String processStatus = String.valueOf(variablesLocal.get("processStatus"));

        // 字典编码
        String bizKey = "emergency_rehearsa";
        // 对应业务值
        String bizKeyId = String.valueOf(variablesLocal.get("bizKeyId"));
        // 上报人
        String createBy = String.valueOf(variablesLocal.get("createBy"));
        // 整改人
        String rectifyPeople;

        MsgTemplateVO msgTemplateVO = new MsgTemplateVO();

        List<String> userIdList = new ArrayList<>();

        TEmergencyRehearsal tEmergencyRehearsal = tEmergencyRehearsalService.getById(bizKeyId);
        if (ObjectUtil.isNotEmpty(tEmergencyRehearsal.getParticipantIds())){
            String[] split = tEmergencyRehearsal.getParticipantIds().split(",");
            for (String s : split) {
                userIdList.add(s);
            }
        }

        String totalCommandId = tEmergencyRehearsal.getTotalCommandId();
        for (int i = 0; i < userIdList.size(); i++) {
            if (!userIdList.contains(totalCommandId)) {
                userIdList.add(totalCommandId);
            }
        }

        //start_notification

        msgTemplateVO.setTemplateContent(tEmergencyRehearsal.getRehearsalPlanName() + "已于" + DateUtil.format(new Date(),"yyyy-MM-dd HH:mm:ss")
                + "开始,请您按时参加"
               );

        userIdList.add(createBy);

        msgTemplateVO.setTemplateTypeName(name);
        msgTemplateVO.setTemplateType("start_notification");
//        TMsgNoticeService tMsgNoticeService=new TMsgNoticeServiceImpl();
        List<TMsgNotice> tMsgNotices = tMsgNoticeService.generateMsgNotice(bizKey, bizKeyId, userIdList, msgTemplateVO);
        System.err.println(JSONArray.toJSONString(tMsgNotices));
        tMsgNoticeService.saveBatch(tMsgNotices);
    }
}
