package com.testor.module.environment.model.dto;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author rsq
 * @program zlmy_boot
 * @return
 **/
@Data
public class TEnvironmentMonthlyPo {

    @ApiModelProperty(value = "机构名称")
    @ExcelProperty(value = {"基层企业"})
    @TableField("org_name")
    private String orgName;

    @ApiModelProperty(value = "businessDepartmentName")
    @ExcelProperty(value = {"经营部"})
    @TableField("regional_org_name")
    private String businessDepartmentName;

    @ApiModelProperty(value = "大区")
    @ExcelProperty(value = {"大区"})
    private String regionalOrgName;

    @ApiModelProperty(value = "上报日期")
    @ExcelProperty(value = {"月份"})
    @TableField("month")
    private String month;

    @ApiModelProperty(value = "流程状态")
    @ExcelProperty(value = {"审核状态"})
    @TableField("process_status")
    private String processStatus;

    @ApiModelProperty(value = "煤炭(标准量)")
    @ExcelProperty(value = {"能源消耗量", "煤炭","煤炭(标准量)"})
    private String energyCoal;

    @ApiModelProperty(value = "原煤（实物量）")
    @ExcelProperty(value = {"能源消耗量", "煤炭", "原煤（实物量）"})
    private String energyCoalAmount;

    @ApiModelProperty(value = "电力(能源消耗量)")
    @ExcelProperty(value = {"能源消耗量", "电力"})
    private String energyPower;

    @ApiModelProperty(value = "汽油(能源消耗量)")
    @ExcelProperty(value = {"能源消耗量", "汽油"})
    private String energyGasoline;

    @ApiModelProperty(value = "柴油(能源消耗量)")
    @ExcelProperty(value = {"能源消耗量", "柴油"})
    private String energyDerv;

    @ApiModelProperty(value = "燃料油(能源消耗量)")
    @ExcelProperty(value = {"能源消耗量", "燃料油"})
    private String energyFuel;

    @ApiModelProperty(value = "天然气(能源消耗量)")
    @ExcelProperty(value = {"能源消耗量", "天然气"})
    private String energyNatural;

    @ApiModelProperty(value = "热力(能源消耗量)")
    @ExcelProperty(value = {"能源消耗量", "热力"})
    private String energyHeating;

    @ApiModelProperty(value = "其它能源(能源消耗量)")
    @ExcelProperty(value = {"能源消耗量", "其它能源"})
    private String energyOther;

    @ApiModelProperty(value = "综合能源消耗量(能源消耗量)")
    @ExcelProperty(value = {"能源消耗量", "综合能源消耗量"})
    private String energySynthesize;

    @ApiModelProperty(value = "用新水量(用水量)")
    @ExcelProperty(value = {"用水量", "用新水量"})
    private String waterNew;

    @ApiModelProperty(value = "重复用水量(用水量)")
    @ExcelProperty(value = {"用水量", "重复用水量"})
    private String waterRepetition;

    @ApiModelProperty(value = "重复用水率(用水量)")
    @ExcelProperty(value = {"用水量", "重复用水率"})
    private String waterRate;

    @ApiModelProperty(value = "废水排放量(水污染物 排入外环境 废水排放量)")
    @ExcelIgnore
    private String wPollutantODischarge;

    @ApiModelProperty(value = "化学需氧量排放量COD (水污染物 排入外环境 废水排放量)")
    @ExcelIgnore
    private String wPollutantOCod;

    @ApiModelProperty(value = "氨氮排放量 (水污染物 排入外环境 废水排放量)")
    @ExcelIgnore
    private String wPollutantONh3n;

    @ApiModelProperty(value = "废水排放量(水污染物  排入市政管网或污水处理厂炭（标煤） 废水排放量)")
    @ExcelIgnore
    private String wPollutantIDischarge;

    @ApiModelProperty(value = "化学需氧量排放量COD (水污染物  排入市政管网或污水处理厂炭（标煤） 废水排放量)")
    @ExcelIgnore
    private String wPollutantICod;

    @ApiModelProperty(value = "氨氮排放量 (水污染物  排入市政管网或污水处理厂炭（标煤） 废水排放量)")
    @ExcelIgnore
    private String wPollutantINh3n;

    @ApiModelProperty(value = "废水排放量(水污染物  第三方运收 废水排放量)")
    @ExcelIgnore
    private String wPollutantThirdDischarge;

    @ApiModelProperty(value = "化学需氧量排放量COD (水污染物  第三方运收 废水排放量)")
    @ExcelIgnore
    private String wPollutantThirdCod;

    @ApiModelProperty(value = "氨氮排放量 (水污染物  第三方运收 废水排放量)")
    @ExcelIgnore
    private String wPollutantThirdNh3n;

    @ApiModelProperty(value = "合计(水污染物 废水排放量)")
    @ExcelIgnore
    private String wPollutantDischargeSum;

    @ApiModelProperty(value = "合计(水污染物 化学需氧量排放量（COD）)")
    @ExcelIgnore
    private String wPollutantCodSum;

    @ApiModelProperty(value = "合计(水污染物  氨氮排放量)")
    @ExcelIgnore
    private String wPollutantNh3nSum;


    @ApiModelProperty(value = "废水排放量(水污染物 排入外环境 废水排放量)")
    @ExcelProperty(value = {"水污染物", "排入外环境","废水排放量"})
    @TableField("w_pollutant_o_discharge")
    private String pollutantODischarge;

    @ApiModelProperty(value = "化学需氧量排放量COD (水污染物 排入外环境 废水排放量)")
    @ExcelProperty(value = {"水污染物", "排入外环境","化学需氧量排放量COD"})
    @TableField("w_pollutant_o_cod")
    private String pollutantOCod;

    @ApiModelProperty(value = "氨氮排放量 (水污染物 排入外环境 废水排放量)")
    @ExcelProperty(value = {"水污染物", "排入外环境","氨氮排放量"})
    @TableField("w_pollutant_o_NH3N")
    private String pollutantONh3n;

    @ApiModelProperty(value = "废水排放量(水污染物  排入市政管网或污水处理厂炭（标煤） 废水排放量)")
    @ExcelProperty(value = {"水污染物", "排入市政管网或污水处理厂炭（标煤）","废水排放量"})
    @TableField("w_pollutant_i_discharge")
    private String pollutantIDischarge;

    @ApiModelProperty(value = "化学需氧量排放量COD (水污染物  排入市政管网或污水处理厂炭（标煤） 废水排放量)")
    @ExcelProperty(value = {"水污染物", "排入市政管网或污水处理厂炭（标煤）","化学需氧量排放量COD"})
    @TableField("w_pollutant_i_cod")
    private String pollutantICod;

    @ApiModelProperty(value = "氨氮排放量 (水污染物  排入市政管网或污水处理厂炭（标煤） 废水排放量)")
    @ExcelProperty(value = {"水污染物", "排入市政管网或污水处理厂炭（标煤）","氨氮排放量"})
    @TableField("w_pollutant_i_NH3N")
    private String pollutantINh3n;

    @ApiModelProperty(value = "废水排放量(水污染物  第三方运收 废水排放量)")
    @ExcelProperty(value = {"水污染物", "第三方运收","废水排放量"})
    @TableField("w_pollutant_third_discharge")
    private String pollutantThirdDischarge;

    @ApiModelProperty(value = "化学需氧量排放量COD (水污染物  第三方运收 废水排放量)")
    @ExcelProperty(value = {"水污染物", "第三方运收","化学需氧量排放量COD"})
    @TableField("w_pollutant_third_cod")
    private String pollutantThirdCod;

    @ApiModelProperty(value = "氨氮排放量 (水污染物  第三方运收 废水排放量)")
    @ExcelProperty(value = {"水污染物", "第三方运收","氨氮排放量"})
    @TableField("w_pollutant_third_NH3N")
    private String pollutantThirdNh3n;

    @ApiModelProperty(value = "合计(水污染物 废水排放量)")
    @ExcelProperty(value = {"水污染物","合计", "废水排放量"})
    @TableField("w_pollutant_discharge_sum")
    private String pollutantDischargeSum;

    @ApiModelProperty(value = "合计(水污染物 化学需氧量排放量（COD）)")
    @ExcelProperty(value = {"水污染物","合计", "化学需氧量排放量（COD）"})
    @TableField("w_pollutant_cod_sum")
    private String pollutantCodSum;

    @ApiModelProperty(value = "合计(水污染物  氨氮排放量)")
    @ExcelProperty(value = {"水污染物","合计", "氨氮排放量"})
    @TableField("w_pollutant_NH3N_sum")
    private String pollutantNh3nSum;

    @ApiModelProperty(value = "烟（粉）尘排放量(大气污染物)")
    @ExcelProperty(value = {"大气污染物", "烟（粉）尘排放量"})
    @TableField("atmosphere_pollutant_stack")
    private String atmospherePollutantStack;

    @ApiModelProperty(value = "二氧化硫排放量(大气污染物)")
    @ExcelProperty(value = {"大气污染物", "二氧化硫排放量"})
    @TableField("atmosphere_pollutant_so2")
    private String atmospherePollutantSo2;

    @ApiModelProperty(value = "氮氧化物排放量(大气污染物)")
    @ExcelProperty(value = {"大气污染物", "氮氧化物排放量"})
    @TableField("atmosphere_pollutant_NH3n")
    private String atmospherePollutantNh3n;

    @ApiModelProperty(value = "挥发性有机物排放量(大气污染物)")
    @ExcelProperty(value = {"大气污染物", "挥发性有机物排放量"})
    @TableField("atmosphere_pollutant_NH3n_organic")
    private String atmospherePollutantNh3nOrganic;

    @ApiModelProperty(value = "二氧化碳排放量（测量值）(大气污染物)")
    @ExcelProperty(value = {"大气污染物", "二氧化碳排放量（测量值）"})
    @TableField("atmosphere_pollutant_NH3n_co2")
    private String atmospherePollutantNh3nCo2;

    @ApiModelProperty(value = "二氧化碳排放量（计算值）(大气污染物)")
    @ExcelProperty(value = {"大气污染物", "二氧化碳排放量（计算值）"})
    @TableField("atmosphere_pollutant_NH3n_count")
    private String atmospherePollutantNh3nCount;

    @ApiModelProperty(value = "炉渣(一般固体废物)")
    @ExcelProperty(value = {"一般固体废物", "炉渣"})
    @TableField("solid_slag")
    private String solidSlag;

    @ApiModelProperty(value = "筛下物(一般固体废物)")
    @ExcelProperty(value = {"一般固体废物", "筛下物"})
    @TableField("solid_sieve")
    private String solidSieve;

    @ApiModelProperty(value = "其它固废(一般固体废物)")
    @ExcelProperty(value = {"一般固体废物", "其它固废"})
    @TableField("solid_other")
    private String solidOther;

    @ApiModelProperty(value = "一般固体废物产生量(一般固体废物)")
    @ExcelProperty(value = {"一般固体废物", "一般固体废物产生量"})
    @TableField("solid_produce")
    private String solidProduce;

    @ApiModelProperty(value = "综合利用量(一般固体废物)")
    @ExcelProperty(value = {"一般固体废物", "综合利用量"})
    @TableField("solid_use")
    private String solidUse;

    @ApiModelProperty(value = "市政处理量(一般固体废物)")
    @ExcelProperty(value = {"一般固体废物", "市政处理量"})
    @TableField("solid_municipal")
    private String solidMunicipal;

    @ApiModelProperty(value = "一般固体废物处理量(一般固体废物)")
    @ExcelProperty(value = {"一般固体废物", "一般固体废物处理量"})
    @TableField("solid_dispose")
    private String solidDispose;

    @ApiModelProperty(value = "一般固体废物综合利用率(一般固体废物)")
    @ExcelProperty(value = {"一般固体废物", "一般固体废物综合利用率"})
    @TableField("solid_ratio")
    private String solidRatio;

    @ApiModelProperty(value = "危险废物产生量(危险废物)")
    @ExcelProperty(value = {"危险废物", "危险废物产生量"})
    @TableField("risk_produce")
    private String riskProduce;

    @ApiModelProperty(value = "危险废物处置量(危险废物)")
    @ExcelProperty(value = {"危险废物", "危险废物处置量"})
    @TableField("risk_dispose")
    private String riskDispose;

    @ApiModelProperty(value = "危险废物处置率(危险废物)")
    @ExcelProperty(value = {"危险废物", "危险废物处置率"})
    @TableField("risk_ratio")
    private String riskRatio;

    @ApiModelProperty(value = "节能投入(节能环保投入)")
    @ExcelProperty(value = {"节能环保投入", "节能投入"})
    @TableField("energy_put")
    private String energyPut;

    @ApiModelProperty(value = "环保投入(节能环保投入)")
    @ExcelProperty(value = {"节能环保投入", "环保投入"})
    @TableField("recycle_put")
    private String recyclePut;

    @ApiModelProperty(value = "")
    @TableField("operating_income")
    @ExcelProperty(value = {"营业收入"})
    private String operatingIncome;

    public void setwPollutantODischarge(String wPollutantODischarge) {
        this.pollutantODischarge = wPollutantODischarge;
    }

    public void setwPollutantOCod(String wPollutantOCod) {
        this.pollutantOCod = wPollutantOCod;
    }

    public void setwPollutantONh3n(String wPollutantONh3n) {
        this.pollutantONh3n = wPollutantONh3n;
    }

    public void setwPollutantIDischarge(String wPollutantIDischarge) {
        this.pollutantIDischarge = wPollutantIDischarge;
    }

    public void setwPollutantICod(String wPollutantICod) {
        this.pollutantICod = wPollutantICod;
    }

    public void setwPollutantINh3n(String wPollutantINh3n) {
        this.pollutantINh3n = wPollutantINh3n;
    }

    public void setwPollutantThirdDischarge(String wPollutantThirdDischarge) {
        this.pollutantThirdDischarge = wPollutantThirdDischarge;
    }

    public void setwPollutantThirdCod(String wPollutantThirdCod) {
        this.pollutantThirdCod = wPollutantThirdCod;
    }

    public void setwPollutantThirdNh3n(String wPollutantThirdNh3n) {
        this.pollutantThirdNh3n = wPollutantThirdNh3n;
    }

    public void setwPollutantDischargeSum(String wPollutantDischargeSum) {
        this.pollutantDischargeSum = wPollutantDischargeSum;
    }

    public void setwPollutantCodSum(String wPollutantCodSum) {
        this.pollutantCodSum = wPollutantCodSum;
    }

    public void setwPollutantNh3nSum(String wPollutantNh3nSum) {
        this.pollutantNh3nSum = wPollutantNh3nSum;
    }
}
