package com.testor.module.fives.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.module.fives.model.domain.TFivesToolOpl;
import com.testor.module.fives.model.dto.TFivesToolOplDelParam;
import com.testor.module.fives.model.dto.TFivesToolOplParam;
import com.testor.module.fives.service.TFivesToolOplService;
import com.tongtech.tfw.backend.common.biz.constants.BizConstants;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.biz.models.BizGeneralResponse;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import com.tongtech.tfw.backend.core.helper.StringHelper;
import com.tongtech.tfw.backend.core.helper.TypeHelper;
import com.tongtech.tfw.backend.core.helper.bean.BeanHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * 5s工具运用oplController
 *
 * @author testor-framework
 * @date 2022-07-21 15:56:54
 */
@RestController
@RequestMapping("/module/fives/tool/opl")
@Api(value = "TFivesToolOpl", tags = "5s工具运用opl")
@Slf4j
public class TFivesToolOplController extends SuperController {
    @Autowired
    private TFivesToolOplService tFivesToolOplService;

    /* Generated Method*/
    @ApiOperation(value = "新增 5s工具运用opl", notes = "Add TFivesToolOpl")
    @PostMapping(value = "/add")
    public BaseResponse<TFivesToolOpl> addEntity(@RequestBody TFivesToolOpl addRequest) {
        return tFivesToolOplService.addOpl(addRequest);
    }


    @ApiOperation(value = "获取 5s工具运用opl ", notes = "Get TFivesToolOpl By Id")
    @GetMapping(value = "/get")
    public BaseResponse<TFivesToolOpl> getById(String id) {
        BaseResponse<TFivesToolOpl> baseResponse = new BaseResponse<>();
        if (StringHelper.isNotEmpty(id)) {
            // TODO 按需求添加业务异常判断
            TFivesToolOpl data = tFivesToolOplService.getById(id);
            baseResponse.setData(data);
        }
        return baseResponse;
    }

    @ApiOperation(value = "修改 5s工具运用opl ", notes = "Update TFivesToolOpl By Id")
    @PutMapping(value = "/update")
    public BaseResponse<BizGeneralResponse> updateEntity(@RequestBody TFivesToolOpl updateRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(updateRequest) && StringHelper.isNotEmpty(updateRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TFivesToolOpl data = BeanHelper.beanToBean(updateRequest, TFivesToolOpl.class);
            boolean result = tFivesToolOplService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "删除 5s工具运用opl ", notes = "delete TFivesToolOpl By Id")
    @PutMapping(value = "/delete")
    public BaseResponse<BizGeneralResponse> deleteEntity(@RequestBody TFivesToolOplDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && StringHelper.isNotEmpty(deleteRequest.getId())) {
            // TODO 按需求添加数据去重，特殊值设定，业务异常
            TFivesToolOpl data = new TFivesToolOpl();
            data.setId(deleteRequest.getId());
            data.setStatus(BizConstants.STATUS_DELETE);
            boolean result = tFivesToolOplService.updateById(data);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "批量删除5s工具运用opl", notes = "delete TFivesToolOpl by batch Id")
    @PutMapping(value = "/batch_delete")
    public BaseResponse<BizGeneralResponse> deleteEntityBatch(
            @RequestBody TFivesToolOplDelParam deleteRequest) {
        BaseResponse<BizGeneralResponse> baseResponse = new BaseResponse<>();
        if (ObjectHelper.isNotEmpty(deleteRequest) && (!deleteRequest.getIds().isEmpty())) {
            /* 批量删除 */
            List<TFivesToolOpl> tFivesToolOplList = new ArrayList<>();
            for (String id : deleteRequest.getIds()) {
                TFivesToolOpl data = new TFivesToolOpl();
                data.setId(id);
                data.setStatus(BizConstants.STATUS_DELETE);
                tFivesToolOplList.add(data);
            }
            boolean result = tFivesToolOplService.updateBatchById(tFivesToolOplList);
            baseResponse.setData(
                    BizGeneralResponse.builder().result(TypeHelper.castToString(result)).build());
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 5s工具运用opl 分页列表", notes = "List TFivesToolOpl with page")
    @GetMapping(value = "/list")
    public BaseResponse<BaseResponseList<TFivesToolOpl>> listEntity(TFivesToolOplParam param) {
        BaseResponse<BaseResponseList<TFivesToolOpl>> baseResponse = new BaseResponse<>();
        Long page =
                StringHelper.isEmpty(param.getPage()) ? BizConstants.PAGE : Long.valueOf(param.getPage());
        Long limit =
                StringHelper.isEmpty(param.getLimit()) ? BizConstants.LIMIT : Long.valueOf(param.getLimit());
        Page<TFivesToolOpl> resultPage = new Page<>(page, limit);
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TFivesToolOpl> queryWrapper = this.createQuery(param);
        Page<TFivesToolOpl> resultList = tFivesToolOplService.page(resultPage, queryWrapper);
        BaseResponseList<TFivesToolOpl> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList.getRecords());
        baseResponseList.setTotal(resultList.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value = "获取 5s工具运用opl 列表", notes = "List TFivesToolOpl all")
    @GetMapping(value = "/datas")
    public BaseResponse<BaseResponseList<TFivesToolOpl>> listAllEntity(TFivesToolOplParam param) {
        BaseResponse<BaseResponseList<TFivesToolOpl>> baseResponse = new BaseResponse<>();
        // TODO 根据需求修改查询条件及查询参数
        QueryWrapper<TFivesToolOpl> queryWrapper = this.createQuery(param);
        List<TFivesToolOpl> resultList = tFivesToolOplService.list(queryWrapper);
        BaseResponseList<TFivesToolOpl> baseResponseList = new BaseResponseList<>();
        baseResponseList.setData(resultList);
        baseResponseList.setTotal(resultList.size());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    /* Private Methods */

    /**
     * 列表查询条件及查询参数
     */
    private QueryWrapper<TFivesToolOpl> createQuery(TFivesToolOplParam queryParam) {
        QueryWrapper<TFivesToolOpl> queryWrapper = new QueryWrapper<>();
        if (StringHelper.isNotEmpty(queryParam.getRefId())) {
            queryWrapper.eq(TFivesToolOpl.REF_ID, queryParam.getRefId());
        }
        if (StringHelper.isNotEmpty(queryParam.getParentId())) {
            queryWrapper.eq(TFivesToolOpl.PARENT_ID, queryParam.getParentId());
        }
        if (StringHelper.isNotEmpty(queryParam.getTenantId())) {
            queryWrapper.eq(TFivesToolOpl.TENANT_ID, queryParam.getTenantId());
        }
        if (StringHelper.isNotEmpty(queryParam.getProcessId())) {
            queryWrapper.eq(TFivesToolOpl.PROCESS_ID, queryParam.getProcessId());
        }
        if (StringHelper.isNotEmpty(queryParam.getProcessStatus())) {
            queryWrapper.eq(TFivesToolOpl.PROCESS_STATUS, queryParam.getProcessStatus());
        }
        if (StringHelper.isNotEmpty(queryParam.getKapType())) {
            queryWrapper.eq(TFivesToolOpl.KAP_TYPE, queryParam.getKapType());
        }
        if (StringHelper.isNotEmpty(queryParam.getThemeName())) {
            queryWrapper.like(TFivesToolOpl.THEME_NAME, queryParam.getThemeName());
        }
        if (StringHelper.isNotEmpty(queryParam.getGroupName())) {
            queryWrapper.like(TFivesToolOpl.GROUP_NAME, queryParam.getGroupName());
        }
        if (StringHelper.isNotEmpty(queryParam.getCourseDes())) {
            queryWrapper.eq(TFivesToolOpl.COURSE_DES, queryParam.getCourseDes());
        }
        if (StringHelper.isNotEmpty(queryParam.getImage1())) {
            queryWrapper.eq(TFivesToolOpl.IMAGE_1, queryParam.getImage1());
        }
        if (StringHelper.isNotEmpty(queryParam.getImage2())) {
            queryWrapper.eq(TFivesToolOpl.IMAGE_2, queryParam.getImage2());
        }
        if (StringHelper.isNotEmpty(queryParam.getImage3())) {
            queryWrapper.eq(TFivesToolOpl.IMAGE_3, queryParam.getImage3());
        }
        if (StringHelper.isNotEmpty(queryParam.getStatus())) {
            queryWrapper.eq(TFivesToolOpl.STATUS, queryParam.getStatus());
        } else {
            queryWrapper.ne(TFivesToolOpl.STATUS, BizConstants.STATUS_DELETE);
        }
        if (StringHelper.isNotEmpty(queryParam.getOrderBy())) {
            if (StringHelper.isNotEmpty(queryParam.getOrderType())
                    && BizConstants.ASC.equals(queryParam.getOrderType())) {
                queryWrapper.orderByAsc(queryParam.getOrderBy());
            } else {
                queryWrapper.orderByDesc(queryParam.getOrderBy());
            }
        } else {
            queryWrapper.orderByDesc(TFivesToolOpl.UPDATE_DATE);
        }
        return queryWrapper;
    }
}
