package com.testor.module.fives.model.excel;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;


/**
 * 5s标准验收管理对象 t_fives_standard
 *
 * @author testor-framework
 * @date 2022-07-11 14:00:17
 */
@Data
@ApiModel(value = "TFivesStandardReport对象", description = "")
public class TFivesStandardReport {
    private static final long serialVersionUID = 1L;

    /**
     * 标准类型（字典key - FIVES_STANDARD_TYPE）
     */
    @ApiModelProperty(value = "标准类型（字典key - FIVES_STANDARD_TYPE）")
    private String standardType;

    /**
     * 分项
     */
    @ApiModelProperty(value = "分项")
    private String subOption;

    /**
     * 子项
     */
    @ApiModelProperty(value = "子项")
    private String child;

    /**
     * 主要内容名称
     */
    @ApiModelProperty(value = "主要内容名称")
    private String name;

    /**
     * 评分要点内容
     */
    @ApiModelProperty(value = "评分要点内容")
    private String content;

    /**
     * 分值（类型为大类时，分值为总和；类型为小类时，分值是单项分值）
     */
    @ApiModelProperty(value = "分值（类型为大类时，分值为总和；类型为小类时，分值是单项分值）", example = "0")
    private BigDecimal score;

    /**
     * 评分细则
     */
    @ApiModelProperty(value = "评分细则")
    private String detailRules;

}
