package com.testor.module.hazard.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.testor.biz.sys.user.model.domain.SysUser;
import com.testor.module.contractor.common.model.constant.ContractorProcessStatus;
import com.testor.module.hazard.model.domain.TContractorAccessLog;
import com.testor.module.hazard.model.domain.TContractorAccessLogApproval;
import com.testor.module.hazard.model.dto.TContractorAccessLogApprovalParam;
import com.testor.module.hazard.model.dto.TContractorAccessLogParam;
import com.testor.module.hazard.service.TContractorAccessLogApprovalService;
import com.testor.module.iam.service.SysUserService;
import com.tongtech.tfw.backend.common.biz.models.BaseResponse;
import com.tongtech.tfw.backend.common.biz.models.BaseResponseList;
import com.tongtech.tfw.backend.common.models.supers.SuperController;
import com.tongtech.tfw.backend.core.helper.ObjectHelper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/hazard/accessLogApproval")
@Api(value = "TContractorAccessLog", tags = "承包商修改日志审核")
@Slf4j
public class TContractorAccessLogApprovalController extends SuperController {

    @Autowired
    private TContractorAccessLogApprovalService tContractorAccessLogApprovalService;

    @Autowired
    private SysUserService userService;

    @ApiOperation(value = "新增 承包商修改日志审核", notes = "Add TContractorAccessLog")
    @PostMapping(value = "/add")
    public BaseResponse<TContractorAccessLogApproval> addEntity(@RequestBody List<TContractorAccessLogApproval> addRequest) {
        BaseResponse<TContractorAccessLogApproval> baseResponse=new BaseResponse<>();
        if(ObjectHelper.isNotEmpty(addRequest)){
            tContractorAccessLogApprovalService.insertBatchContractorAccessLog(addRequest);
        }
        return baseResponse;
    }

    @ApiOperation(value = "获取 承包商修改日志审核 分页列表", notes = "List THazardWorkPlan with page")
    @GetMapping(value = "/list")
    public  BaseResponse<BaseResponseList<TContractorAccessLogApproval>>listEntity(TContractorAccessLogApprovalParam param){
        BaseResponse<BaseResponseList<TContractorAccessLogApproval>>baseResponse=new BaseResponse<>();
        Page<TContractorAccessLogApproval> tContractorAccessLogApprovalPage = tContractorAccessLogApprovalService.queryContractorAccessLogApproval(param);
        BaseResponseList<TContractorAccessLogApproval> baseResponseList=new BaseResponseList<>();
        baseResponseList.setData(tContractorAccessLogApprovalPage.getRecords());
        baseResponseList.setTotal(tContractorAccessLogApprovalPage.getTotal());
        baseResponse.setData(baseResponseList);
        return baseResponse;
    }

    @ApiOperation(value = "准入管理修改获取审批人", notes = "List THazardWorkPlan with page")
    @GetMapping(value = "/selectUserIdsByOrgId")
    public  BaseResponse<List<SysUser>> selectUserIdsByOrgId(@RequestParam("orgId") String orgId){
        BaseResponse<List<SysUser>> baseResponse=new BaseResponse<>();
        List<SysUser> sysUsers = userService.getApprovalUsers(orgId);
        baseResponse.setData(sysUsers);
        return baseResponse;
    }


    @ApiOperation(value = "根据合同准入管理ID和审批状态查询审批记录数量", notes = "List THazardWorkPlan with page")
    @GetMapping(value = "/selectCountByContractorAllowIdAndApprovalStatus")
    public  BaseResponse<Integer> selectCountByContractorAllowIdAndApprovalStatus(@RequestParam("contractorAllowId") String contractorAllowId){
        BaseResponse<Integer>baseResponse=new BaseResponse<>();
        int count = tContractorAccessLogApprovalService.selectCountByContractorAllowIdAndApprovalStatus(contractorAllowId, ContractorProcessStatus.UNDER_REVIEW.getValue());
        baseResponse.setData(count);
        return baseResponse;
    }


    @ApiOperation(value = "批量更新审批状态", notes = "List THazardWorkPlan with page")
    @PostMapping(value = "/updateApprovalStatus")
    public  BaseResponse<Integer> updateApprovalStatus(@RequestBody TContractorAccessLogApprovalParam param){
        BaseResponse<Integer>baseResponse=new BaseResponse<>();
        int count = tContractorAccessLogApprovalService.updateApprovalStatus(param);
        baseResponse.setData(count);
        return baseResponse;
    }


}
